/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.Filter;
import edu.berkeley.nlp.starcraft.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

public class Utils {
    public static Game mGame = Game.getInstance();
    public static int mapheight = 0;
    public static int mapwidth = 0;
    public static Bwta myBwta = Bwta.getInstance();

    public static <T> T popFirstFromSet(Collection<T> set, Filter<T> filter) {
        Object found = null;
        for (Object object : set) {
            if (!filter.test(object)) continue;
            found = object;
            break;
        }
        if (found != null) {
            set.remove(found);
        }
        return (T)found;
    }

    public static <T> T findFirst(Collection<T> set, Filter<T> filter) {
        for (T t : set) {
            if (!filter.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> List<T> findAll(Collection<? extends T> set, Filter<? super T> filter) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : set) {
            if (!filter.test(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> int countIf(Collection<T> set, Filter<T> filter) {
        int i = 0;
        for (T t : set) {
            if (!filter.test(t)) continue;
            ++i;
        }
        return i;
    }

    public static void copyFileHard(String from, String to) {
        try {
            Utils.copyFile(from, to);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(String from, String to) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        inChannel = new FileInputStream(new File(from)).getChannel();
        outChannel = new FileOutputStream(new File(to)).getChannel();
        inChannel.transferTo(0L, inChannel.size(), outChannel);
        if (inChannel != null) {
            inChannel.close();
        }
        if (outChannel != null) {
            outChannel.close();
        }
    }

    public static Properties loadPropertiesFile(String propertiesFile) {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(propertiesFile);
            props.load(in);
            in.close();
            return props;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static <T> T getObjectByClassName(String className) {
        try {
            return (T)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Log.getLog("Util").fatal("Instantiation:", e);
            throw new RuntimeException("Failed to instantiate: " + className, e);
        }
    }

    public static Class<?> getClassByClassName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load: " + className);
        }
    }

    public static Object getEnumValue(Class enumClass, String valueName) {
        try {
            return enumClass.getMethod("valueOf", String.class).invoke((Object)enumClass, valueName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T randomChoice(Collection<? extends T> col) {
        int n = (int)(Math.random() * (double)col.size());
        Iterator<T> it = col.iterator();
        while (n-- != 0) {
            it.next();
        }
        return it.next();
    }

    public static boolean isWalkable(TilePosition tp) {
        if (mapheight == 0) {
            mapheight = Game.getInstance().getMapHeight();
        }
        if (mapwidth == 0) {
            mapwidth = Game.getInstance().getMapWidth();
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (Game.getInstance().isWalkable(tp.x() * 4 + i, tp.y() * 4 + j)) continue;
                return false;
            }
        }
        if (tp.x() < 0 || tp.x() > mapwidth - 1) {
            return false;
        }
        return tp.y() >= 0 && tp.y() <= mapheight - 1;
    }

    public static boolean isTileWalkable(Position p) {
        TilePosition tp = new TilePosition(p);
        if (mapheight == 0) {
            mapheight = Game.getInstance().getMapHeight();
        }
        if (mapwidth == 0) {
            mapwidth = Game.getInstance().getMapWidth();
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (Game.getInstance().isWalkable(tp.x() * 4 + i, tp.y() * 4 + j)) continue;
                return false;
            }
        }
        if (tp.x() < 0 || tp.x() > mapwidth - 1) {
            return false;
        }
        return tp.y() >= 0 && tp.y() <= mapheight - 1;
    }

    public static TilePosition nearestWalkableTile(TilePosition tp) {
        if (Utils.isWalkable(tp)) {
            return tp;
        }
        for (int dx = -2; dx < 2; ++dx) {
            for (int dy = -2; dy < 2; ++dy) {
                TilePosition newpos = new TilePosition(tp.x() + dx, tp.y() + dy);
                if (!Utils.isWalkable(newpos)) continue;
                return newpos;
            }
        }
        return null;
    }

    public static Position nearestWalkablePosition(TilePosition tp) {
        if (Utils.isWalkable(tp)) {
            return Position.centerOfTile(tp);
        }
        for (int dx = -2; dx < 2; ++dx) {
            for (int dy = -2; dy < 2; ++dy) {
                TilePosition newpos = new TilePosition(tp.x() + dx, tp.y() + dy);
                if (!Utils.isWalkable(newpos)) continue;
                return Position.centerOfTile(newpos);
            }
        }
        return null;
    }

    public static TilePosition nearestDroppableTile(TilePosition tp) {
        if (Utils.isWalkable(tp) && Utils.tileClear(tp)) {
            return tp;
        }
        for (int dx = -2; dx < 2; ++dx) {
            for (int dy = -2; dy < 2; ++dy) {
                TilePosition newpos = new TilePosition(tp.x() + dx, tp.y() + dy);
                if (!Utils.isWalkable(newpos) || !Utils.tileClear(newpos)) continue;
                return newpos;
            }
        }
        return null;
    }

    public static boolean tileClear(TilePosition tp) {
        for (ROUnit rOUnit : mGame.unitsOnTile(tp)) {
            if (!rOUnit.getType().isBuilding() && rOUnit.getPlayer() == mGame.self()) continue;
            return false;
        }
        return true;
    }

    public static Position nearestChoke(Position p) {
        Position bestpos = null;
        double bestdist = Double.POSITIVE_INFINITY;
        for (Chokepoint c : myBwta.getChokepoints()) {
            double d = c.getCenter().getDistance(p);
            if (!(d < bestdist)) continue;
            bestdist = d;
            bestpos = c.getCenter();
        }
        return bestpos;
    }

    public static Position biggestChoke(Position p) {
        Position bestpos = null;
        double biggest = 0.0;
        Region region = null;
        for (Region r : myBwta.getRegions()) {
            if (!r.contains(p)) continue;
            region = r;
            break;
        }
        if (region == null) {
            return Position.INVALID;
        }
        for (Chokepoint c : region.getChokepoints()) {
            double d = c.getWidth();
            if (!(d > biggest)) continue;
            biggest = d;
            bestpos = c.getCenter();
        }
        return bestpos;
    }

    public static boolean fullVisible(TilePosition seed, UnitType bldg) {
        for (int i = 0; i < bldg.tileWidth(); ++i) {
            for (int j = 0; j < bldg.tileHeight(); ++j) {
                if (mGame.isVisible(new TilePosition(seed.x() + i, seed.y() + j))) continue;
                return false;
            }
        }
        return true;
    }

    public static double getValueRO(Collection<ROUnit> army) {
        int minval = 1;
        int gasval = 0;
        for (ROUnit e : army) {
            minval += e.getType().mineralPrice();
            gasval += e.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public static double getValue(Collection<Unit> army) {
        int minval = 1;
        int gasval = 0;
        for (Unit e : army) {
            minval += e.getType().mineralPrice();
            gasval += e.getType().gasPrice();
        }
        return minval + gasval * 2;
    }

    public static TilePosition closestTile(Collection<TilePosition> tiles, TilePosition goal) {
        double bestd = Double.POSITIVE_INFINITY;
        TilePosition best = null;
        for (TilePosition tp : tiles) {
            double d = tp.getDistance(goal);
            if (!(d < bestd)) continue;
            bestd = d;
            best = tp;
        }
        return best;
    }

    public static void drawArrowMap(Position start, Position end, Color color) {
        mGame.drawLineMap(start, end, color);
        double slope = (double)(end.y() - start.y()) / (double)(end.x() - start.x());
    }
}

