/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.Log;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;
import org.bwapi.proxy.util.Pair;

public class UnitUtils {
    public static Log logger = Log.getLog("UnitUtils");

    public static <T extends ROUnit> T getClosest(ROUnit u, Collection<T> opps) {
        return (T)((ROUnit)UnitUtils.getClosestAndDistance(u, opps).getFirst());
    }

    public static Unit assumeControl(ROUnit r) {
        return ((Unit)r).commandableUnit(Game.getInstance().getDefaultValidator());
    }

    public static double getClosestDistance(ROUnit u, Collection<? extends ROUnit> opps) {
        return UnitUtils.getClosestAndDistance(u, opps).getSecond();
    }

    public static <T extends ROUnit> Pair<T, Double> getClosestAndDistance(ROUnit u, Collection<T> opps) {
        ROUnit max = null;
        double distance = Double.POSITIVE_INFINITY;
        for (ROUnit other : opps) {
            double otherDistance = u.getDistance(other);
            if (!(distance > otherDistance)) continue;
            distance = otherDistance;
            max = other;
        }
        return Pair.makePair(max, distance);
    }

    public static <T extends ROUnit> T getClosest(Position pos, Collection<T> opps) {
        return (T)((ROUnit)UnitUtils.getClosestAndDistance(pos, opps).getFirst());
    }

    public static double getClosestDistance(Position pos, Collection<? extends Unit> opps) {
        return UnitUtils.getClosestAndDistance(pos, opps).getSecond();
    }

    public static <T extends ROUnit> Pair<T, Double> getClosestAndDistance(Position pos, Collection<T> opps) {
        ROUnit max = null;
        double distance = Double.POSITIVE_INFINITY;
        for (ROUnit other : opps) {
            double otherDistance = other.getLastKnownPosition().getDistance(pos);
            if (!(distance > otherDistance)) continue;
            distance = otherDistance;
            max = other;
        }
        return Pair.makePair(max, distance);
    }

    public static Position getClosestPosition(Position pos, Collection<Position> opps) {
        Position max = null;
        double distance = Double.POSITIVE_INFINITY;
        for (Position other : opps) {
            double otherDistance = other.getDistance(pos);
            if (!(distance > otherDistance)) continue;
            distance = otherDistance;
            max = other;
        }
        return max;
    }

    public static List<ROUnit> getAllMy(UnitType type) {
        ArrayList<ROUnit> us = new ArrayList<ROUnit>();
        for (ROUnit rOUnit : Game.getInstance().self().getUnits()) {
            if (!rOUnit.getType().equals(type)) continue;
            us.add(rOUnit);
        }
        return us;
    }

    public static Position avePos(Collection<? extends ROUnit> units) {
        int x = 0;
        int y = 0;
        int n = 0;
        for (ROUnit rOUnit : units) {
            x += rOUnit.getPosition().x();
            y += rOUnit.getPosition().y();
            ++n;
        }
        if (n == 0) {
            return Position.INVALID;
        }
        return new Position(x / n, y / n);
    }

    public static Position closestWalkableAvePos(Collection<? extends ROUnit> units) {
        int x = 0;
        int y = 0;
        int n = 0;
        for (ROUnit rOUnit : units) {
            x += rOUnit.getPosition().x();
            y += rOUnit.getPosition().y();
            ++n;
        }
        if (n == 0) {
            return Position.INVALID;
        }
        Position p = new Position(x / n, y / n);
        if (Utils.isTileWalkable(p)) {
            return p;
        }
        TilePosition tilePosition = new TilePosition(p);
        for (int dx = -1; dx < 1; ++dx) {
            for (int dy = -1; dy < 1; ++dy) {
                TilePosition newpos = new TilePosition(tilePosition.x() + dx, tilePosition.y() + dy);
                if (!Utils.isWalkable(newpos)) continue;
                return Position.centerOfTile(newpos);
            }
        }
        return p;
    }

    public static double groupRadius(Collection<? extends ROUnit> units) {
        Position center = UnitUtils.avePos(units);
        double r = 0.0;
        for (ROUnit rOUnit : units) {
            r = Math.max(r, rOUnit.getLastKnownPosition().getDistance(center));
        }
        return r;
    }

    public static Position medianPos(Collection<? extends ROUnit> units) {
        if (units.size() == 0) {
            return Position.INVALID;
        }
        int[] xes = new int[units.size()];
        int[] yes = new int[units.size()];
        int i = 0;
        for (ROUnit rOUnit : units) {
            if (rOUnit.isLoaded()) continue;
            xes[i] = rOUnit.getLastKnownPosition().x();
            yes[i++] = rOUnit.getLastKnownPosition().y();
        }
        Arrays.sort(xes);
        Arrays.sort(yes);
        int x = UnitUtils.pickMedian(xes);
        int n = UnitUtils.pickMedian(yes);
        return new Position(x, n);
    }

    private static int pickMedian(int[] sortedArray) {
        if (sortedArray.length % 2 == 1) {
            return sortedArray[sortedArray.length / 2];
        }
        int mid = sortedArray.length / 2;
        return (sortedArray[mid - 1] + sortedArray[mid]) / 2;
    }

    public static int getUtility(UnitType type) {
        int futureValue;
        int cost = UnitUtils.getCost(type);
        int n = futureValue = type.isWorker() ? 50 : 0;
        if (type.equals(UnitType.ZERG_HATCHERY) || type.equals(UnitType.ZERG_LAIR) || type.equals(UnitType.ZERG_HIVE) || type.equals(UnitType.PROTOSS_NEXUS) || type.equals(UnitType.TERRAN_COMMAND_CENTER)) {
            futureValue = 300;
        }
        return cost + futureValue;
    }

    public static int getCost(UnitType type) {
        if (type.equals(UnitType.PROTOSS_ARCHON)) {
            return 2 * UnitUtils.getCost(UnitType.PROTOSS_HIGH_TEMPLAR);
        }
        if (type.equals(UnitType.PROTOSS_DARK_ARCHON)) {
            return 2 * UnitUtils.getCost(UnitType.PROTOSS_DARK_TEMPLAR);
        }
        int cost = type.mineralPrice() + type.gasPrice() * 3;
        if (type.isTwoUnitsInOneEgg()) {
            cost /= 2;
        }
        if (type.getName().startsWith("ZERG") && type.whatBuilds() != null && !type.whatBuilds().getKey().equals(UnitType.NONE) && !type.whatBuilds().getKey().equals(UnitType.ZERG_LARVA)) {
            cost += UnitUtils.getCost(type.whatBuilds().getKey());
        }
        return cost;
    }

    public static double pairDistance(Collection<? extends ROUnit> us, Collection<? extends ROUnit> them) {
        double d = Double.POSITIVE_INFINITY;
        for (ROUnit rOUnit : us) {
            for (ROUnit rOUnit2 : them) {
                double newd = rOUnit.getDistance(rOUnit2);
                if (!(newd < d)) continue;
                d = newd;
            }
        }
        return d;
    }

    public static int getRange(WeaponType weapon, Player player) {
        return 0;
    }
}

