/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bwapi.proxy.model.ROUnit;

public class UnitBox {
    private Set<ROUnit> units = new HashSet<ROUnit>();
    private Set<ROUnit> buildings = new HashSet<ROUnit>();
    private Set<ROUnit> resourceDepots = new HashSet<ROUnit>();
    private Set<ROUnit> workers = new HashSet<ROUnit>();

    public void addUnit(ROUnit u) {
        this.units.add(u);
        if (u.getType().isBuilding()) {
            this.buildings.add(u);
        }
        if (u.getType().isResourceDepot()) {
            this.resourceDepots.add(u);
        }
        if (u.getType().isWorker()) {
            this.workers.add(u);
        }
    }

    public boolean removeUnit(ROUnit u) {
        this.buildings.remove(u);
        this.resourceDepots.remove(u);
        this.workers.remove(u);
        return this.units.remove(u);
    }

    public Set<ROUnit> getUnits() {
        return Collections.unmodifiableSet(this.units);
    }

    public Set<ROUnit> getBuildings() {
        return Collections.unmodifiableSet(this.buildings);
    }

    public Set<ROUnit> getResourceDepots() {
        return Collections.unmodifiableSet(this.resourceDepots);
    }

    public Set<ROUnit> getWorkers() {
        return Collections.unmodifiableSet(this.workers);
    }
}

