/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.BwapiAppender;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.bwapi.proxy.model.Game;

public class Log {
    private static final String TIMESTAMP = new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(new GregorianCalendar().getTime());
    private static final String DEFAULT_CONSOLE_LOG_FILE = "Log files/overmind-console_" + TIMESTAMP + ".log";
    private static final String DEFAULT_LOG_FILE = "Log files/overmind_" + TIMESTAMP + ".log";
    public static final String LOG_KEY = "logFile";
    private static Map<String, Log> logs = new HashMap<String, Log>();
    private static String consoleLogFile = DEFAULT_CONSOLE_LOG_FILE;
    private static String logFile = DEFAULT_LOG_FILE;
    private Logger consoleLogger;
    private Logger fileLogger;

    public static Log getLog(String name) {
        Log log = logs.get(name);
        if (log == null) {
            log = new Log(name);
            logs.put(name, log);
        }
        return log;
    }

    private Log(String name) {
        if (name.length() > 0) {
            this.consoleLogger = Logger.getLogger("console." + name);
            this.fileLogger = Logger.getLogger("file." + name);
        } else {
            this.consoleLogger = Logger.getLogger("console");
            this.fileLogger = Logger.getLogger("file");
        }
    }

    public static void initLogger(Level consoleLevel, Level fileLevel) throws IOException {
        BwapiAppender bwapiAppender = new BwapiAppender();
        bwapiAppender.setLayout(new OvermindLayout(true));
        Logger.getLogger("console").addAppender(bwapiAppender);
        FileAppender consoleAppender = new FileAppender(new OvermindLayout(), consoleLogFile, false);
        consoleAppender.setBufferedIO(false);
        consoleAppender.setBufferSize(4096);
        Logger.getLogger("console").addAppender(consoleAppender);
        FileAppender fileAppender = new FileAppender(new OvermindLayout(), logFile, false);
        fileAppender.setBufferedIO(true);
        fileAppender.setBufferSize(4096);
        Logger.getLogger("file").addAppender(fileAppender);
        Log.setConsoleLevel("", consoleLevel);
        Log.setFileLevel("", fileLevel);
    }

    public static void setConsoleLevel(String name, Level level) {
        if (name.length() > 0) {
            Logger.getLogger("console." + name).setLevel(level);
        } else {
            Logger.getLogger("console").setLevel(level);
        }
    }

    public static void setFileLevel(String name, Level level) {
        if (name.length() > 0) {
            Logger.getLogger("file." + name).setLevel(level);
        } else {
            Logger.getLogger("file").setLevel(level);
        }
    }

    public static Collection<String> getLogNames() {
        return Collections.unmodifiableSet(logs.keySet());
    }

    public void log(Priority priority, Object message) {
        this.consoleLogger.log(priority, message);
        this.fileLogger.log(priority, message);
    }

    public void log(Priority priority, Object message, Throwable t) {
        this.consoleLogger.log(priority, message, t);
        this.fileLogger.log(priority, message, t);
    }

    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public static void setLogFile(String logFileName) {
        logFile = logFileName;
    }

    public static class OvermindLayout
    extends SimpleLayout {
        boolean truncate;

        public OvermindLayout() {
            this(false);
        }

        public OvermindLayout(boolean truncate) {
            this.truncate = truncate;
        }

        @Override
        public String format(LoggingEvent event) {
            String frames = Integer.toString(Game.getInstance().getFrameCount());
            String[] parts = event.getLoggerName().split("[.]");
            String name = String.format("%s" + (20 - frames.length()), parts[parts.length - 1]);
            String output = "[" + frames + ":" + name + "] " + super.format(event);
            if (this.truncate) {
                return output.substring(0, Math.min(240, output.length()));
            }
            return output;
        }
    }
}

