/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.PriorityQueue;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FastPriorityQueue<E>
implements PriorityQueue<E>,
Serializable {
    private static final long serialVersionUID = 5724671156522771658L;
    int size;
    int capacity;
    Object[] elements;
    double[] priorities;

    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean containsKey(E e) {
        for (int i = 0; i < this.elements.length; ++i) {
            Object element = this.elements[i];
            if (e == null && element == null) {
                return true;
            }
            if (e == null || !e.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getPriority(E e) {
        double bestPriority = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.elements.length; ++i) {
            Object element = this.elements[i];
            if ((e != null || element != null) && (e == null || !e.equals(element)) || !(this.priorities[i] > bestPriority)) continue;
            bestPriority = this.priorities[i];
        }
        return bestPriority;
    }

    @Override
    public double removeKey(E e) {
        throw new UnsupportedOperationException();
    }

    protected void grow(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        double[] newPriorities = new double[newCapacity];
        if (this.size > 0) {
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            System.arraycopy(this.priorities, 0, newPriorities, 0, this.priorities.length);
        }
        this.elements = newElements;
        this.priorities = newPriorities;
        this.capacity = newCapacity;
    }

    protected int parent(int loc) {
        return (loc - 1) / 2;
    }

    protected int leftChild(int loc) {
        return 2 * loc + 1;
    }

    protected int rightChild(int loc) {
        return 2 * loc + 2;
    }

    protected void heapifyUp(int loc) {
        while (true) {
            if (loc == 0) {
                return;
            }
            int parent = this.parent(loc);
            if (!(this.priorities[loc] > this.priorities[parent])) break;
            this.swap(loc, parent);
            loc = parent;
        }
    }

    protected final void heapifyDown(int loc) {
        while (true) {
            int max = loc;
            int leftChild = this.leftChild(loc);
            if (leftChild < this.size()) {
                double rightChildPriority;
                int rightChild;
                double leftChildPriority = this.priorities[leftChild];
                double priority = this.priorities[loc];
                if (leftChildPriority > priority) {
                    max = leftChild;
                }
                if ((rightChild = this.rightChild(loc)) < this.size() && (rightChildPriority = this.priorities[this.rightChild(loc)]) > priority && rightChildPriority > leftChildPriority) {
                    max = rightChild;
                }
            }
            if (max == loc) {
                return;
            }
            this.swap(loc, max);
            loc = max;
        }
    }

    protected final void swap(int loc1, int loc2) {
        double tempPriority = this.priorities[loc1];
        Object tempElement = this.elements[loc1];
        this.priorities[loc1] = this.priorities[loc2];
        this.elements[loc1] = this.elements[loc2];
        this.priorities[loc2] = tempPriority;
        this.elements[loc2] = tempElement;
    }

    @Override
    public E removeFirst() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        Object element = this.elements[0];
        this.swap(0, this.size - 1);
        --this.size;
        this.elements[this.size] = null;
        this.heapifyDown(0);
        return (E)element;
    }

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public E next() {
        return this.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getFirst() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[0];
    }

    @Override
    public double getPriority() {
        if (this.size() > 0) {
            return this.priorities[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void setPriority(E key, double priority) {
        if (this.size == this.capacity) {
            this.grow(2 * this.capacity + 1);
        }
        this.elements[this.size] = key;
        this.priorities[this.size] = priority;
        this.heapifyUp(this.size);
        ++this.size;
    }

    public String toString() {
        return this.toString(this.size());
    }

    @Override
    public String toString(int maxKeysToPrint) {
        int numKeysPrinted;
        FastPriorityQueue<E> pq = this.deepCopy();
        StringBuilder sb = new StringBuilder("[");
        for (numKeysPrinted = 0; numKeysPrinted < maxKeysToPrint && !pq.isEmpty(); ++numKeysPrinted) {
            double priority = pq.getPriority();
            Object element = pq.removeFirst();
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(priority);
            if (numKeysPrinted >= this.size() - 1) continue;
            sb.append(", ");
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public Counter<E> asCounter() {
        FastPriorityQueue<E> pq = this.deepCopy();
        Counter counter = new Counter();
        while (!pq.isEmpty()) {
            double priority = pq.getPriority();
            Object element = pq.removeFirst();
            counter.incrementCount(element, priority);
        }
        return counter;
    }

    public FastPriorityQueue<E> deepCopy() {
        FastPriorityQueue<E> clonePQ = new FastPriorityQueue<E>();
        clonePQ.size = this.size;
        clonePQ.capacity = this.capacity;
        clonePQ.elements = new Object[this.capacity];
        clonePQ.priorities = new double[this.capacity];
        if (this.size() > 0) {
            System.arraycopy(this.elements, 0, clonePQ.elements, 0, this.size());
            System.arraycopy(this.priorities, 0, clonePQ.priorities, 0, this.size());
        }
        return clonePQ;
    }

    public FastPriorityQueue() {
        this(15);
    }

    public FastPriorityQueue(int capacity) {
        int legalCapacity = 0;
        while (legalCapacity < capacity) {
            legalCapacity = 2 * legalCapacity + 1;
        }
        this.grow(legalCapacity);
    }

    public static void main(String[] args) {
        FastPriorityQueue<String> pq = new FastPriorityQueue<String>();
        System.out.println(pq);
        pq.setPriority("one", 1.0);
        System.out.println(pq);
        pq.setPriority("three", 3.0);
        System.out.println(pq);
        pq.setPriority("one", 1.1);
        System.out.println(pq);
        pq.setPriority("two", 2.0);
        System.out.println(pq);
        System.out.println(pq.toString(2));
        while (pq.hasNext()) {
            System.out.println((String)pq.next());
        }
    }
}

