/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Digraph<T> {
    private Map<T, Node> dataToNodes = new HashMap<T, Node>();

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("digraph G {\n");
        for (Node n : this.dataToNodes.values()) {
            for (Node src : n.getIncomingNodes()) {
                b.append("  " + src.data + " -> " + n.data + "\r\n");
            }
            b.append(n.data + "\r\n");
        }
        b.append("}");
        return b.toString();
    }

    public Node getNode(T data) {
        return this.dataToNodes.get(data);
    }

    public boolean containsNodeFor(T data) {
        return this.dataToNodes.containsKey(data);
    }

    public Iterable<Node> allNodes() {
        return this.dataToNodes.values();
    }

    public Set<T> nodesWithParents(Set<T> data) {
        HashSet ret = new HashSet();
        for (Node n : this.allNodes()) {
            boolean unsatisfied = false;
            for (Node parent : n.incomingNodes) {
                if (data.contains(parent.data)) continue;
                unsatisfied = true;
                break;
            }
            if (unsatisfied) continue;
            ret.add(n.data);
        }
        return ret;
    }

    public Digraph<T> subgraphWithSinks(Set<T> data) {
        Digraph<T> result = new Digraph<T>();
        for (T datum : data) {
            Node n = this.getNode(datum);
            super.ensurePredecessorOfNode(n);
        }
        return result;
    }

    public Digraph<T> subgraphWithSinksAndBlocks(Set<T> data, Set<T> blocks) {
        Digraph<T> result = new Digraph<T>();
        for (T datum : data) {
            Node n = this.getNode(datum);
            if (n == null) {
                throw new RuntimeException("No node for " + datum);
            }
            super.ensurePredecessorOfNode(n, blocks);
        }
        return result;
    }

    private Node ensurePredecessorOfNode(Node n) {
        if (this.containsNodeFor(n.data)) {
            return this.getNode(n.data);
        }
        Node rn = this.addNode(n.data);
        for (Node pred : n.incomingNodes) {
            Node rp = this.ensurePredecessorOfNode(pred);
            this.addEdge(rp, rn);
        }
        return rn;
    }

    private Node ensurePredecessorOfNode(Node n, Set<T> blocks) {
        if (this.containsNodeFor(n.data)) {
            return this.getNode(n.data);
        }
        Node rn = this.addNode(n.data);
        for (Node pred : n.incomingNodes) {
            if (blocks.contains(pred.getData())) continue;
            Node rp = this.ensurePredecessorOfNode(pred, blocks);
            this.addEdge(rp, rn);
        }
        return rn;
    }

    public Node addNode(T newData) {
        Node node;
        if (!this.dataToNodes.containsKey(newData)) {
            node = new Node(newData);
            this.dataToNodes.put(newData, node);
        } else {
            node = this.dataToNodes.get(newData);
        }
        return node;
    }

    public void removeNode(Node nodeToRemove) {
        for (Node incomingNode : nodeToRemove.incomingNodes) {
            incomingNode.outgoingNodes.remove(nodeToRemove);
        }
        for (Node outgoingNode : nodeToRemove.outgoingNodes) {
            outgoingNode.incomingNodes.remove(nodeToRemove);
        }
        this.dataToNodes.remove(nodeToRemove.data);
    }

    public void addEdge(T origin, T target) {
        this.addEdge(this.addNode(origin), this.addNode(target));
    }

    public void addEdge(Node origin, Node target) {
        origin.outgoingNodes.add(target);
        target.incomingNodes.add(origin);
    }

    public void close(Collection<Node> dataToNodesToClose) {
        for (Node nodeToClose : dataToNodesToClose) {
            this.closeNode(nodeToClose);
        }
    }

    private void closeNode(Node nodeToClose) {
        for (Node incomingNode : nodeToClose.incomingNodes) {
            for (Node outgoingNode : nodeToClose.outgoingNodes) {
                if (incomingNode.equals(outgoingNode)) continue;
                this.addEdge(incomingNode, outgoingNode);
            }
        }
        this.removeNode(nodeToClose);
    }

    public List<Node> createListOfSourceNodes() {
        ArrayList<Node> sourceNodes = new ArrayList<Node>();
        for (T data : this.dataToNodes.keySet()) {
            Node node = this.dataToNodes.get(data);
            if (!node.incomingNodes.isEmpty()) continue;
            sourceNodes.add(node);
        }
        return sourceNodes;
    }

    public List<Node> createListOfSinkNodes() {
        ArrayList<Node> sinkNodes = new ArrayList<Node>();
        for (T data : this.dataToNodes.keySet()) {
            Node node = this.dataToNodes.get(data);
            if (!node.outgoingNodes.isEmpty()) continue;
            sinkNodes.add(node);
        }
        return sinkNodes;
    }

    public class Node {
        public T data;
        public Set<Node> incomingNodes = new HashSet<Node>();
        public Set<Node> outgoingNodes = new HashSet<Node>();

        public String toString() {
            return "Node [data=" + this.data + ", incomingNodes=" + this.incomingNodes + ", outgoingNodes=" + this.outgoingNodes + "]";
        }

        public Node(T newData) {
            this.data = newData;
        }

        public T getData() {
            return this.data;
        }

        public Set<Node> getIncomingNodes() {
            return this.incomingNodes;
        }

        public Set<Node> getOutgoingNodes() {
            return this.outgoingNodes;
        }
    }
}

