/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.CounterMap;
import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;
import edu.berkeley.nlp.starcraft.util.PriorityQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Counters {
    private static final Random random = new Random();

    public static <E> Counter<E> normalize(Counter<E> counter) {
        Counter<E> normalizedCounter = new Counter<E>();
        double total = counter.totalCount();
        for (E key : counter.keySet()) {
            normalizedCounter.setCount(key, counter.getCount(key) / total);
        }
        return normalizedCounter;
    }

    public static <K, V> CounterMap<K, V> conditionalNormalize(CounterMap<K, V> counterMap) {
        CounterMap<K, V> normalizedCounterMap = new CounterMap<K, V>();
        for (K key : counterMap.keySet()) {
            Counter<V> normalizedSubCounter = Counters.normalize(counterMap.getCounter(key));
            for (V value : normalizedSubCounter.keySet()) {
                double count = normalizedSubCounter.getCount(value);
                normalizedCounterMap.setCount(key, value, count);
            }
        }
        return normalizedCounterMap;
    }

    public static <E> String toBiggestValuesFirstString(Counter<E> c) {
        return c.asPriorityQueue().toString();
    }

    public static <E> String toBiggestValuesFirstString(Counter<E> c, int k) {
        PriorityQueue<E> pq = c.asPriorityQueue();
        FastPriorityQueue largestK = new FastPriorityQueue();
        while (largestK.size() < k && pq.hasNext()) {
            double firstScore = pq.getPriority();
            Object first = pq.next();
            largestK.setPriority(first, firstScore);
        }
        return ((Object)largestK).toString();
    }

    public static <E> List<E> sortedKeys(Counter<E> counter) {
        ArrayList sortedKeyList = new ArrayList();
        PriorityQueue<E> pq = counter.asPriorityQueue();
        while (pq.hasNext()) {
            sortedKeyList.add(pq.next());
        }
        return sortedKeyList;
    }

    public static <E> double jensenShannonDivergence(Counter<E> x, Counter<E> y) {
        double avg;
        double yVal;
        double xVal;
        double sum = 0.0;
        double xTotal = x.totalCount();
        double yTotal = y.totalCount();
        for (E key : x.keySet()) {
            xVal = x.getCount(key) / xTotal;
            yVal = y.getCount(key) / yTotal;
            avg = 0.5 * (xVal + yVal);
            sum += xVal * Math.log(xVal / avg);
        }
        for (E key : y.keySet()) {
            xVal = x.getCount(key) / xTotal;
            yVal = y.getCount(key) / yTotal;
            avg = 0.5 * (xVal + yVal);
            sum += yVal * Math.log(yVal / avg);
        }
        return sum / 0.5;
    }

    public static <E> double dotProduct(Counter<E> x, Counter<E> y) {
        double total = 0.0;
        for (E keyX : x.keySet()) {
            total += x.getCount(keyX) * y.getCount(keyX);
        }
        return total;
    }

    public static <E> Counter<E> subtract(Counter<E> x, Counter<E> y) {
        Counter<E> copy = new Counter<E>();
        copy.incrementAll(x);
        for (Map.Entry<E, Double> e : y.entrySet()) {
            copy.decrementCount(e.getKey(), e.getValue());
        }
        return copy;
    }

    public static <E> E sample(Counter<E> counter) {
        double total = counter.totalCount();
        double rand = random.nextDouble();
        double sum = 0.0;
        if (total <= 0.0) {
            throw new RuntimeException("Non-positive counter total: " + total);
        }
        for (E key : counter.keySet()) {
            double count = counter.getCount(key);
            if (count < 0.0) {
                throw new RuntimeException("Negative count in counter: " + key + " => " + count);
            }
            double prob = count / total;
            if (!(rand < (sum += prob))) continue;
            return key;
        }
        throw new RuntimeException("Shouldn't Reach Here");
    }
}

