/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.MapFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.util.Pair;

public class CounterMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 5724671156522771668L;
    MapFactory<V, Double> mf;
    Map<K, Counter<V>> counterMap;
    int currentModCount = 0;
    int cacheModCount = -1;
    double cacheTotalCount = 0.0;

    protected Counter<V> ensureCounter(K key) {
        Counter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            valueCounter = new Counter<V>(this.mf);
            this.counterMap.put(key, valueCounter);
        }
        return valueCounter;
    }

    public Set<K> keySet() {
        return this.counterMap.keySet();
    }

    public void setCount(K key, V value, double count) {
        Counter<V> valueCounter = this.ensureCounter(key);
        valueCounter.setCount(value, count);
        ++this.currentModCount;
    }

    public void incrementCount(K key, V value, double count) {
        Counter<V> valueCounter = this.ensureCounter(key);
        valueCounter.incrementCount(value, count);
        ++this.currentModCount;
    }

    public void incrementAll(Map<K, V> map, double count) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.incrementCount(entry.getKey(), entry.getValue(), count);
        }
    }

    public void incrementAll(Collection<Pair<K, V>> entries, double count) {
        for (Pair<K, V> entry : entries) {
            this.incrementCount(entry.getFirst(), entry.getSecond(), count);
        }
    }

    public double getCount(K key, V value) {
        Counter<V> valueCounter = this.counterMap.get(key);
        if (valueCounter == null) {
            return 0.0;
        }
        return valueCounter.getCount(value);
    }

    public Counter<V> getCounter(K key) {
        return this.ensureCounter(key);
    }

    public boolean containsKey(K key) {
        return this.counterMap.containsKey(key);
    }

    public double totalCount() {
        if (this.currentModCount != this.cacheModCount) {
            double total = 0.0;
            for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
                Counter<V> counter = entry.getValue();
                total += counter.totalCount();
            }
            this.cacheTotalCount = total;
            this.cacheModCount = this.currentModCount;
        }
        return this.cacheTotalCount;
    }

    public int totalSize() {
        int total = 0;
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            Counter<V> counter = entry.getValue();
            total += counter.size();
        }
        return total;
    }

    public void normalize() {
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            Counter<V> counter = entry.getValue();
            counter.normalize();
        }
        ++this.currentModCount;
    }

    public int size() {
        return this.counterMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[\n");
        for (Map.Entry<K, Counter<V>> entry : this.counterMap.entrySet()) {
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public CounterMap() {
        this(new MapFactory.HashMapFactory(), new MapFactory.HashMapFactory());
    }

    public CounterMap(MapFactory<K, Counter<V>> outerMF, MapFactory<V, Double> innerMF) {
        this.mf = innerMF;
        this.counterMap = outerMF.buildMap();
    }

    public static void main(String[] args) {
        CounterMap<String, String> bigramCounterMap = new CounterMap<String, String>();
        bigramCounterMap.incrementCount("people", "run", 1.0);
        bigramCounterMap.incrementCount("cats", "growl", 2.0);
        bigramCounterMap.incrementCount("cats", "scamper", 3.0);
        System.out.println(bigramCounterMap);
        System.out.println("Entries for cats: " + bigramCounterMap.getCounter("cats"));
        System.out.println("Entries for dogs: " + bigramCounterMap.getCounter("dogs"));
        System.out.println("Count of cats scamper: " + bigramCounterMap.getCount("cats", "scamper"));
        System.out.println("Count of snakes slither: " + bigramCounterMap.getCount("snakes", "slither"));
        System.out.println("Total size: " + bigramCounterMap.totalSize());
        System.out.println("Total count: " + bigramCounterMap.totalCount());
        System.out.println(bigramCounterMap);
    }

    public Set<Map.Entry<K, Counter<V>>> entrySet() {
        return this.counterMap.entrySet();
    }
}

