/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.util;

import edu.berkeley.nlp.starcraft.overmind.Overmind;
import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;

public class ConvexHull {
    List<Vector> hull;
    private List<Line> lines;

    public ConvexHull(Collection<Position> positions) {
        HashSet<Vector> inputs = new HashSet<Vector>();
        for (Position u : positions) {
            inputs.add(new Vector(u));
        }
        this.lines = new ArrayList<Line>();
        this.hull = this.getConvexHull(inputs);
    }

    public int size() {
        return this.hull.size();
    }

    public Vector closestPointOnHull(Vector toTest) {
        if (this.hull.size() == 1) {
            return this.hull.get(0);
        }
        double minDist = Double.MAX_VALUE;
        Vector best = null;
        for (int i = 0; i < this.hull.size(); ++i) {
            Vector b;
            Vector a = this.hull.get((i + 1) % this.hull.size());
            Vector closest = Vector.ClosestPointOnLineSegment(a, b = this.hull.get(i), toTest);
            double distance = closest.distanceTo(toTest);
            if (!(minDist > distance)) continue;
            minDist = distance;
            best = closest;
        }
        return best;
    }

    public double distanceToHull(Vector toTest) {
        if (this.withinHull(toTest)) {
            return 0.0;
        }
        return this.closestPointOnHull(toTest).distanceTo(toTest);
    }

    public boolean withinHull(Vector toTest) {
        if (this.hull.size() == 0) {
            return false;
        }
        if (this.hull.size() == 1) {
            return toTest.equals(this.hull.get(0));
        }
        int sign = 0;
        for (int i = 0; i < this.hull.size(); ++i) {
            Vector line = this.hull.get(i == 0 ? this.hull.size() - 1 : i - 1).sub(this.hull.get(i));
            Vector point = toTest.sub(this.hull.get(i));
            int newSign = this.sign(point.crossProduct(line));
            if (newSign != 0 && sign != 0 && newSign != sign) {
                return false;
            }
            sign = newSign;
        }
        return true;
    }

    int sign(double val) {
        if (val > 0.0) {
            return 1;
        }
        if (val < 0.0) {
            return -1;
        }
        return 0;
    }

    private List<Vector> getConvexHull(Set<Vector> enemies) {
        ArrayList<Vector> hull = new ArrayList<Vector>();
        if (enemies.size() == 0 || enemies.size() == 1) {
            for (Vector enemy : enemies) {
                hull.add(enemy);
            }
            return hull;
        }
        Vector leftmost = null;
        double x = Double.MAX_VALUE;
        for (Vector u : enemies) {
            if (!(u.dx < x)) continue;
            x = u.dx;
            leftmost = u;
        }
        Vector pointOnHull = leftmost;
        Iterator<Vector> tmp = enemies.iterator();
        Vector endpoint = tmp.next();
        if (endpoint.equals(leftmost)) {
            endpoint = tmp.next();
        }
        for (int counter = 0; !endpoint.equals(leftmost) && counter < enemies.size(); ++counter) {
            hull.add(pointOnHull);
            endpoint = null;
            for (Vector enemy : enemies) {
                double angle2;
                if (endpoint == null) {
                    if (enemy.equals(pointOnHull)) continue;
                    endpoint = enemy;
                }
                if (enemy.equals(endpoint) || enemy.equals(pointOnHull)) continue;
                double angle1 = enemy.sub(pointOnHull).getAngle();
                double diff = angle1 - (angle2 = endpoint.sub(pointOnHull).getAngle());
                if (diff < 0.0) {
                    diff += Math.PI * 2;
                }
                if (diff > Math.PI * 2) {
                    diff -= Math.PI * 2;
                }
                if (!(diff < Math.PI)) continue;
                endpoint = enemy;
            }
            this.lines.add(new Line(pointOnHull, endpoint));
            pointOnHull = endpoint;
        }
        return hull;
    }

    public void draw() {
        for (Line l : this.lines) {
            Game.getInstance().drawLineMap((int)((Line)l).pointOnHull.dx, (int)((Line)l).pointOnHull.dy, (int)((Line)l).endpoint.dx, (int)((Line)l).endpoint.dy, Color.WHITE);
        }
    }

    public boolean isEmpty() {
        return this.hull.isEmpty();
    }

    public Vector normalFromNearestVertex(Vector vector) {
        if (this.hull.size() <= 1) {
            return new Vector(Overmind.random.nextDouble() - 0.5, Overmind.random.nextDouble() - 0.5).normalize();
        }
        int closestVertex = this.nearestIndex(vector);
        Vector v = this.hull.get(closestVertex);
        Vector a = v.sub(this.hull.get(closestVertex == 0 ? this.hull.size() - 1 : closestVertex - 1));
        Vector b = v.sub(this.hull.get(closestVertex == this.hull.size() - 1 ? 0 : closestVertex + 1));
        return a.add(b).normalize();
    }

    private int nearestIndex(Vector vector) {
        double minDist = Double.MAX_VALUE;
        int best = -1;
        int i = 0;
        for (Vector v : this.hull) {
            double dist = v.distanceTo(vector);
            if (dist < minDist) {
                minDist = dist;
                best = i;
            }
            ++i;
        }
        return best;
    }

    public Vector nearestVertex(Vector vector) {
        int idx = this.nearestIndex(vector);
        if (idx >= 0) {
            return this.hull.get(idx);
        }
        return null;
    }

    public boolean withinHull(Position p) {
        return this.withinHull(new Vector(p));
    }

    private static class Line {
        private final Vector pointOnHull;
        private final Vector endpoint;

        public Line(Vector pointOnHull, Vector endpoint) {
            this.pointOnHull = pointOnHull;
            this.endpoint = endpoint;
        }
    }
}

