/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.scripting;

import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.scripting.Command;
import edu.berkeley.nlp.starcraft.scripting.Thunk;
import edu.berkeley.nlp.starcraft.util.Log;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bwapi.proxy.model.Game;
import org.python.core.Py;
import org.python.core.PyObject;

public class JythonInterpreter
extends AbstractCerebrate {
    ScriptEngine engine = new ScriptEngineManager().getEngineByName("python");
    Log logger = Log.getLog("jython");

    public JythonInterpreter() {
        this.engine.getContext().setWriter(new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] arg0, int arg1, int arg2) throws IOException {
                Game.getInstance().printf(new String(arg0, arg1, arg2), new Object[0]);
            }
        });
    }

    public void bind(String name, Object o) {
        this.engine.put(name, o);
    }

    public void interpret(String text) {
        try {
            this.engine.eval(text);
        }
        catch (ScriptException e) {
            this.logger.fatal("Script Error:", e);
        }
    }

    public void interpret(Reader text) {
        try {
            this.engine.eval(text);
        }
        catch (ScriptException e) {
            this.logger.fatal("Script Error:", e);
        }
    }

    public void bindCommand(String name, final Command<PyObject> fn) {
        this.engine.put(name, new PyObject(){
            private static final long serialVersionUID = 1L;

            @Override
            public PyObject __call__(PyObject obj) {
                fn.call(obj);
                return Py.None;
            }
        });
    }

    public void bindThunk(String name, final Thunk fn) {
        this.engine.put(name, new PyObject(){
            private static final long serialVersionUID = 1L;

            @Override
            public PyObject __call__() {
                fn.call();
                return Py.None;
            }
        });
    }

    public void bindIntCommand(String name, final Command<Integer> fn) {
        this.engine.put(name, new PyObject(){
            private static final long serialVersionUID = 1L;

            @Override
            public PyObject __call__(PyObject obj) {
                fn.call(obj.asInt());
                return Py.None;
            }
        });
    }

    public void bindStringCommand(String name, final Command<String> fn) {
        this.engine.put(name, new PyObject(){
            private static final long serialVersionUID = 1L;

            @Override
            public PyObject __call__(PyObject obj) {
                fn.call(obj.toString());
                return Py.None;
            }
        });
    }

    public void bindFields(Object o) {
        for (Class<?> c = o.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    this.bind(f.getName(), f.get(o));
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void onSendText(String text) {
        try {
            Object eval = this.engine.eval(text);
            if (eval != null) {
                Game.getInstance().printf("< " + eval, new Object[0]);
            }
        }
        catch (ScriptException e) {
            this.logger.fatal("Script Error:", e);
        }
    }
}

