/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.starcraft.overmind;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Level;
import org.bwapi.proxy.ProxyBot;
import org.bwapi.proxy.model.Flag;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;

public class Overmind
implements ProxyBot {
    public static final String DEFAULT_PROPERTIES_FILE = "resources/overmind.properties";
    public final Properties agentParameters;
    public static Log logger = Log.getLog("Overmind");
    public static Random random = new Random();
    List<Cerebrate> cerebrates;
    private final Strategy strategy;

    public Overmind(Strategy strategy, Properties properties) {
        this.agentParameters = properties;
        this.strategy = strategy;
    }

    private void initialize() {
        try {
            Game game = Game.getInstance();
            game.enableFlag(Flag.USER_INPUT);
            this.cerebrates = new ArrayList<Cerebrate>();
            this.cerebrates.addAll(this.strategy.getTopLevelCerebrates());
        }
        catch (Exception e) {
            logger.fatal("Exception in initialization:", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onStart() {
        try {
            if (this.agentParameters.containsKey("logFile")) {
                Log.setLogFile(this.agentParameters.getProperty("logFile"));
            }
            Log.initLogger(Level.INFO, Level.DEBUG);
        }
        catch (Exception e) {
            Game.getInstance().printf("Logger init exception " + e.getMessage(), new Object[0]);
            int i = 0;
            for (StackTraceElement elem : e.getStackTrace()) {
                if (++i > 10) break;
                Game.getInstance().printf(elem.toString(), new Object[0]);
            }
        }
        this.initialize();
        try {
            logger.info("Undermind online.");
            for (Map.Entry<Object, Object> entry : this.agentParameters.entrySet()) {
                logger.info("  " + entry.getKey() + " = " + entry.getValue());
            }
            logger.info("Strategy: " + this.strategy);
            for (Cerebrate c : this.cerebrates) {
                c.onStart();
            }
        }
        catch (Exception e) {
            logger.fatal("Exception " + e);
            for (StackTraceElement elem : e.getStackTrace()) {
                logger.fatal(elem.toString());
            }
        }
    }

    @Override
    public void onFrame() {
        try {
            for (Cerebrate c : this.cerebrates) {
                try {
                    c.onFrame();
                }
                catch (Exception e) {
                    logger.fatal("Exception in onFrame of cerebrate " + c, e);
                }
            }
        }
        catch (Throwable e) {
            logger.fatal("Exception in onFrame", e);
        }
    }

    @Override
    public void onSendText(String text) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onSendText(text);
            }
            catch (Exception e) {
                logger.fatal("Exception in onFrame of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onEnd(isWinnerFlag);
            }
            catch (Exception e) {
                logger.fatal("Exception in onFrame of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onPlayerLeft(Player player) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onPlayerLeft(player);
            }
            catch (Exception e) {
                logger.fatal("Exception in onPlayerLeft of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onNukeDetect(Position position) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onNukeDetect(position);
            }
            catch (Exception e) {
                logger.fatal("Exception in onNukeDetect of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onReceiveText(Player player, String text) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onReceiveText(player, text);
            }
            catch (Exception e) {
                logger.fatal("Exception in onReceiveText of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onDroppedConnection() {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onDroppedConnection();
            }
            catch (Exception e) {
                logger.fatal("Exception in onDroppedConnection of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitCreate(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitCreate of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitDestroy(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitDestroy of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitHide(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitHide(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitHide of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitMorph(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitMorph of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitRenegade(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitRenegade of cerebrate " + c, e);
            }
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        for (Cerebrate c : this.cerebrates) {
            try {
                c.onUnitShow(unit);
            }
            catch (Exception e) {
                logger.fatal("Exception in onUnitShow of cerebrate " + c, e);
            }
        }
    }
}

