#ifndef WRAITHHK_H
#define WRAITHHK_H
#include "MicroTacticsModel.h"
#include "UnitModel.h"
#include "WraithAerialSquadron.h"
#include "BWTA.h"

using namespace BWTA;

class WraithHunterKillerTactics : public MicroTacticsModel {

public:
	WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u);
	WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u, WraithAerialSquadron* p, InformationManagerAgent* a);
	WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	 void setTarget(Unit* t);
	 void clearTarget();
	void declareTarget();
	virtual void move(Position p);
	 void findNewPoint();
	 void attachIntelligenceModule(InformationManagerAgent* a);
	 	virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* squadTarget;
	UnitModel* myTarget;
	int myTargetFitness;
	Position nextPoint;
	WraithAerialSquadron* parent;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	InformationManagerAgent* intelligenceModule;
	bool repairMode;
		UnitType knownType;
};


#endif