#include "WraithHunterKillerTactics.h"
#include <cmath>
#include <ctime> 

WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	findNewPoint();
	repairMode = false;
	knownType = u->getType();
}

WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u, WraithAerialSquadron* p, InformationManagerAgent* a) {
	element = u;
	intelligenceModule = a;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	parent = p;
	myTargetFitness = 0;
	findNewPoint();
	repairMode = false;
	knownType = u->getType();
}

UnitType WraithHunterKillerTactics::getKnownType() {
	return knownType;
}

WraithHunterKillerTactics::WraithHunterKillerTactics(Unit* u, int movementLag) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	findNewPoint();
	repairMode = false;
}


void WraithHunterKillerTactics::setMovementLag(int l) {
	initialMovementLag = l;
}

void WraithHunterKillerTactics::declareTarget() {
	parent->receiveTarget(myTarget->getUnit(), myTargetFitness);
}

void WraithHunterKillerTactics::move(Position p) {
	// INSTEAD of moving to p, move to the best location you can see from here to p
	int initPopSize = 64;
	int initPopVariance = 256;
	std::vector<Position> population;
	std::vector<Position> solution;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	std::vector<Unit*> dangerFilter;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
			if(target->getType() == UnitTypes::Zerg_Spore_Colony || target->getType() == UnitTypes::Terran_Missile_Turret  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
				dangerFilter.push_back(target);
			}
		}
	}
	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = element->getPosition();
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);


		population.push_back(newPosition);

	}

	// find the best member
	Position bestPosition = element->getPosition();
	int bestFitness = 900000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		
		int threatOfMove = 0;
		for(unsigned int k = 0; k < dangerFilter.size(); k++) {
			int distance = n.getDistance(dangerFilter.at(k)->getPosition());
			int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
			int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
			if(minRange < distance && maxRange >= distance) {
				threatOfMove+=250;
			}
		}

		int fitness = n.getApproxDistance(p) + threatOfMove;

		if(fitness < bestFitness) {
			bestPosition = n;
			bestFitness = fitness;
	}

			element->move(bestPosition);
	
	}
}

void WraithHunterKillerTactics::setTarget(Unit* t) {
	squadTarget = t;
}

void WraithHunterKillerTactics::clearTarget() {
	squadTarget = NULL;
}

void WraithHunterKillerTactics::findNewPoint() {
	if(rand()%100 > 65) {
		nextPoint = Position((rand() % (Broodwar->mapWidth()*32)-2), (rand() % (Broodwar->mapHeight()*32)-2)).makeValid();
	} else {
		std::set<BaseLocation*> b = BWTA::getBaseLocations();

		std::set<BaseLocation*>::const_iterator it(b.begin());
		std::advance(it,rand()%b.size());

		BaseLocation* tar = *it;

		int newX = rand()%256;
		int newY = rand()%256;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		Position p = Position(tar->getPosition().x()+newX, tar->getPosition().y()+newY);
		nextPoint = p;
	}
}

bool WraithHunterKillerTactics::executeTactics() {
	int enemies = 0;
	if(element->getHitPoints() <= element->getType().maxHitPoints()*0.7 && !repairMode) {
		move(intelligenceModule->findHighestConcentrationOf(UnitTypes::Terran_SCV));
		repairMode = true;
		element->decloak();
		return true;
	}
	if(repairMode) {
		if(element->getHitPoints() == element->getType().maxHitPoints()) {
			repairMode = false;
		} else {
			return true;
		}
	}


	std::set<BWAPI::Unit*> neighbours = element->getUnitsInRadius(element->getType().sightRange());

	int detectors = 0;
	int antiAir = 0;
	if(!neighbours.empty()) {
		for (std::set<BWAPI::Unit*>::const_iterator it = neighbours.begin(); it != neighbours.end(); ++it) {
			if((*it)->getPlayer() ==  Broodwar->enemy() && (*it)->getHitPoints() > 0 && !(*it)->getType().isResourceContainer() && !(*it)->getType().isSpecialBuilding()  && !(*it)->getType().isNeutral() && !(*it)->getType() != UnitTypes::Zerg_Egg && (*it)->getType() != UnitTypes::Zerg_Larva ) {
					enemies++;
					if((*it)->getType().isDetector()) {
						detectors++;
				}
					if(element->getType() == Protoss_Photon_Cannon || element->getType() == Terran_Missile_Turret || element->getType() == Zerg_Spore_Colony) {
						if(element->getPosition().getDistance((*it)->getPosition()) < (*it)->getType().airWeapon().maxRange()) {
							findNewPoint();
							return true;
						}
					}
			}
		}
				if(enemies == 0) {
					if(Broodwar->self()->hasResearched(TechTypes::Cloaking_Field)) {
						if(element->isCloaked()) {
							if(element->getEnergy() < 25 || detectors > 0) {
								element->decloak();
							}
						}
					}
				} else {
					if(Broodwar->self()->hasResearched(TechTypes::Cloaking_Field)) {
						if(!element->isCloaked()) {
							if(element->getEnergy() > 50 && detectors == 0) {
								element->cloak();
							}
						}
					}
				}

				//if(squadTarget == NULL) {
				if(myTarget == NULL || !myTarget->isAlive() || !myTarget->getUnit()->isVisible()) {
					std::set<BWAPI::Unit*> neighbours = element->getUnitsInRadius(element->getType().sightRange());
					Unit* bestTarget = NULL;
					int bestFitness = 0;
					int enemies = 0;
					if(!neighbours.empty()) {
						for (std::set<BWAPI::Unit*>::const_iterator it = neighbours.begin(); it != neighbours.end(); ++it)
						{
							if((*it)->getPlayer() != Broodwar->self() && !((*it)->getHitPoints() == 25) && !(*it)->getType().isResourceContainer() && !(*it)->getType().isSpecialBuilding() && !(*it)->getType().isNeutral()) {
								enemies++;
								if(bestTarget == NULL) {
									bestTarget = *it;
									bestFitness = fitnessCalculator->calculateAirFitness(*it);
								}
								int curFitness = fitnessCalculator->calculateAirFitness(*it);
								if(curFitness < bestFitness) {
									bestTarget = *it;
									bestFitness = curFitness;
								}
							}
						}


					}

					if(bestTarget != NULL) {
						myTarget = new UnitModel(bestTarget);
						myTargetFitness = fitnessCalculator->calculateAirFitness(bestTarget);
						declareTarget();
					} else {
						myTarget = NULL;
					}
				} else {
					myTarget = NULL;
				}
				//}
			}



	if(squadTarget != NULL) {
		if(squadTarget->getHitPoints() <= 0) {
			squadTarget = NULL;
			myTarget = NULL;
		} else {
			if(squadTarget->isVisible()) {


				if(element->getGroundWeaponCooldown() > element->getType().groundWeapon().damageCooldown()/4) {
					//if(!element->isMoving()) {
					int tx = squadTarget->getPosition().x();
					int ty = squadTarget->getPosition().y();
					int mx = element->getPosition().x();
					int my = element->getPosition().y();

					int nx = 0;
					int ny = 0;

					// if the enemy is to my right
					if(tx >= mx) {
						// move far left
						nx = (tx-250);
					} else {
						// move far right
						nx = tx+250;
					}

					// if the enemy is below me
					if(ty >= my) {
						// move up
						ny = (ty-250);
					} else {
						// move down
						ny = (ty+250);
					}
					element->stop();
					element->move(Position(nx,ny));	
				} else {
					element->attack(squadTarget);
				}
				return true;
			} else {
				move(squadTarget->getPosition());
				return true;
			}
		}
	}
			if(myTarget != NULL) {
				if(myTarget->getUnit()->isVisible()) {
					element->attack(myTarget->getUnit());
				} else {
					move(myTarget->getLastKnownPosition());
				}
			} else {
				if(Broodwar->getFrameCount()%64 == 0) {
				if(element->getDistance(nextPoint) < element->getType().sightRange()) {
					findNewPoint();
				} else {
					move(nextPoint);
				}
				}

			}


			return true;
	}

	Unit* WraithHunterKillerTactics::getUnit() {
		return element;
	}

	void WraithHunterKillerTactics::attachIntelligenceModule(InformationManagerAgent* a) {
		intelligenceModule = a;
	}