#include "WraithAerialSquadron.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "WraithHunterKillerTactics.h"

WraithAerialSquadron::WraithAerialSquadron(Squad* m, AgentPool* p) {
	dead = false;
	element = m;
	agentPool = p;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnitAt(i));
	}
	m->attachTacticsImplementation(this);
}

void WraithAerialSquadron::assignUnit(Unit* u) {
	if(u->getType() == BWAPI::UnitTypes::Terran_Wraith) {
		unitTactics.push_back(new WraithHunterKillerTactics(u, this, (InformationManagerAgent*)agentPool->getAgent("EI")));
	}	
}

void WraithAerialSquadron::receiveTarget(Unit* u, int f) {
	std::pair<int, Unit*> newTarget;
	newTarget.first = f;
	newTarget.second = u;
	squadTargets.push_back(newTarget);
}

void WraithAerialSquadron::broadcastTarget() {
	Unit* bestTarget = NULL;
	int bestFitness = 9000;
	
	if(!unitTactics.empty()) {
	if(!squadTargets.empty()) {
			////////agentPool->writeDebugMessage("broadcasting target...");
		for(unsigned int i = 0; i < squadTargets.size(); i++) {
			if(squadTargets.at(i).first < bestFitness && squadTargets.at(i).second->getHitPoints() > 0) {
				bestFitness = squadTargets.at(i).first;
				bestTarget = squadTargets.at(i).second;
			}
		}
		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			WraithHunterKillerTactics* u = (WraithHunterKillerTactics*)unitTactics.at(i);
			u->setTarget(bestTarget);
		}
	squadTargets.clear();
	}
	}
}

void WraithAerialSquadron::receiveAlert(Unit* t) {
	assignUnit(t);
}

std::vector<MicroTacticsModel*> WraithAerialSquadron::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit()->getType() == t) {
			subSquad.push_back(u);
		}	
	}
	return subSquad;
}

bool WraithAerialSquadron::execute() {
	// since this squad can have units that haven't yet finished training, we
	// need to ignore those
	////////////////////////agentPool->writeDebugMessage("executing air squadron tactics");
	if(!unitTactics.empty()) {
	// firstly... is the squad dead?
	bool microTacticsExecuted = false;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* m = unitTactics.at(i);
		
		// ignore units under construction 
		if(!m->getUnit()->isCompleted()) {
			continue;
		}

		// firstly, if this guy is dead, get rid of him
		if(m->getUnit()->getHitPoints() <= 0) {
			continue;
		}
		////////////////////////agentPool->writeDebugMessage("seeing which tactics to do...");
		broadcastTarget();
		if(m->executeTactics() == true) {
			microTacticsExecuted = true;
			continue;
		}
	}
	}
	return true;
}

void WraithAerialSquadron::removeUnit( Unit* u )
{

}
