#ifndef VULTUREMICRO_H
#define VULTUREMICRO_H
#include "MicroTacticsModel.h"

class CrawlingBallAttack;


class VultureMicroTactics : public MicroTacticsModel {

public:
	VultureMicroTactics::VultureMicroTactics(Unit* u, CrawlingBallAttack* s);
	VultureMicroTactics::VultureMicroTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	virtual void move(Position p);
	 void patrol(Position p);
	virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* closestEnemy;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int wait;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	Unit* lastTarget;
	CrawlingBallAttack* squadTactics;
	UnitType knownType;
	bool retreating;

	int teleporterClickCount;
	Unit* firstClicked;

};


#endif