#include "VultureMicroTactics.h"
#include "CrawlingBallAttack.h"
#include <cmath>


VultureMicroTactics::VultureMicroTactics(Unit* u, CrawlingBallAttack* s) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	lastTarget = NULL;
	squadTactics = s;
	knownType = u->getType();
	retreating = false;
}

VultureMicroTactics::VultureMicroTactics(Unit* u, int movementLag) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	lastTarget = NULL;
	knownType = u->getType();
	retreating = false;
	squadTactics = NULL;
}
UnitType VultureMicroTactics::getKnownType() {
	return knownType;
}

void VultureMicroTactics::patrol(Position p) {
	int initPopSize = 32;
	int initPopVariance = 256;
	std::vector<Position> population;
	std::vector<Position> solution;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	std::vector<Unit*> dangerFilter;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
			if(target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
				dangerFilter.push_back(target);
			}
		}
	}
	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = element->getPosition();
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(element->getPosition().x()+newX, element->getPosition().y()+newY);

		population.push_back(newPosition);

	}

	// find the best member
	Position bestPosition = element->getPosition();
	int bestFitness = 90000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		int threatOfMove = 0;
		for(unsigned int k = 0; k < dangerFilter.size(); k++) {
			int distance = n.getDistance(dangerFilter.at(k)->getPosition());
			int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
			int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
			if(minRange < distance && maxRange >= distance) {
				threatOfMove+=1000;
			}
		}

		int fitness = n.getDistance(p) + threatOfMove;
		if(fitness < bestFitness && element->hasPath(n)) 
		{
			bestPosition = n;
			bestFitness = fitness;
		}

	}


	element->patrol(bestPosition);


}
void VultureMicroTactics::move(Position p) {
	/*
	int initPopSize = 64;
	int initPopVariance = 6;
	std::vector<TilePosition> population;
	std::vector<Position> solution;
	TilePosition tp = element->getTilePosition();
	// generate population
	for(unsigned int i = 0; i < initPopSize; i++) {
	TilePosition newPosition = tp;
	int newX = rand()%initPopVariance;
	int newY = rand()%initPopVariance;
	if(rand()%100 >= 50) newX = -newX;
	if(rand()%100 >= 50) newY = -newY;
	newPosition = TilePosition(tp.x()+newX, tp.y()+newY).makeValid();
	population.push_back(newPosition);
	}

	// find the best member
	TilePosition bestPosition = element->getTilePosition();
	int bestFitness = 90000;
	for(unsigned int i = 0; i < initPopSize; i++) {
	TilePosition n = population.at(i);
	int threatOfMove = 0;


	int fitness = n.getDistance((TilePosition)p);
	if(fitness < bestFitness && element->hasPath((Position)n) && n.x()%2 == 0 && n.y()%2 == 0) {
	bestPosition = n;
	bestFitness = fitness;
	}

	}
	for(unsigned int i = 0; i < population.size(); i++) {
	Broodwar->drawCircle(CoordinateType::Map, population.at(i).x()*32, population.at(i).y()*32, 8, Colors::Red);
	}

	element->move((Position)bestPosition);
	*/




	int initPopSize = 64;
	int initPopVariance = 256;
	std::vector<Position> population;
	std::vector<Position> solution;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	std::vector<Unit*> dangerFilter;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
			if(target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
				dangerFilter.push_back(target);
			}
		}
	}
	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = element->getPosition();
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(element->getPosition().x()+newX, element->getPosition().y()+newY);

		population.push_back(newPosition);

	}

	// find the best member
	Position bestPosition = element->getPosition();
	int bestFitness = 90000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		int threatOfMove = 0;
		for(unsigned int k = 0; k < dangerFilter.size(); k++) {
			int distance = n.getDistance(dangerFilter.at(k)->getPosition());
			int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
			int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
			if(minRange < distance && maxRange >= distance) {
				threatOfMove+=250;
			}
		}

		int fitness = n.getApproxDistance(p) + threatOfMove;
		if(fitness < bestFitness && element->hasPath(n)) 
		{
			bestPosition = n;
			bestFitness = fitness;
			solution.push_back(n);
		}

	}


	element->move(bestPosition);


}

void VultureMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
	movementLagTimer = l;
}

bool VultureMicroTactics::executeTactics() {
	if(element->isUnderDisruptionWeb()) {
		if(Broodwar->getFrameCount()%8==0) {
			int newX = 120+(rand()%64);
			int newY = 80+(rand()%64);
			if(rand()%100 >= 50) newX = -newX;
			if(rand()%100 >= 50) newY = -newY;
			element->move(Position(element->getPosition().x()+newX,element->getPosition().y()+newY));
		}
	}
	std::vector<Unit*> dangerFilter;
	std::set<Unit*> implacements = element->getUnitsInRadius(element->getType().sightRange());
	for (std::set<BWAPI::Unit*>::const_iterator it = implacements.begin(); it != implacements.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() == Broodwar->enemy() && !target->getType().isNeutral()) {
			if(target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
				dangerFilter.push_back(target);
			}
		}
	}


	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	int nearByEnemies = 0;
	int bestFitness = 0;
	closestEnemy = NULL;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		if((*it)->getPlayer() == Broodwar->enemy() && !(*it)->getType().isFlyer() && (*it)->getHitPoints() > 0 && !(*it)->getType().isNeutral() && !(*it)->getType().isSpecialBuilding() && (*it)->getType() != UnitTypes::Zerg_Larva && (*it)->getType() != UnitTypes::Zerg_Egg && (*it)->getType() != UnitTypes::Zerg_Sunken_Colony && (*it)->getType() != UnitTypes::Terran_Bunker  && (*it)->getType() != UnitTypes::Protoss_Photon_Cannon) {
			nearByEnemies++;	
			if(closestEnemy == NULL || closestEnemy->getHitPoints() <= 0) {
				closestEnemy = *it;
			} else {
				int targetFitness = fitnessCalculator->calculateMechFitness(*it)+(1000-element->getDistance(*it));
				boolean enemyInCover = false;
				for(unsigned int k = 0; k < dangerFilter.size(); k++) {
					int distance = (*it)->getDistance(dangerFilter.at(k)->getPosition());
					int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
					int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
					if(minRange < distance && maxRange >= distance) {
						enemyInCover = true;
						break;
					}
				}
				if(targetFitness > fitnessCalculator->calculateMechFitness(closestEnemy) && !enemyInCover) {
					bestFitness = targetFitness;
					closestEnemy = *it;
				}
			}
		}
	}


	if(squadTactics != NULL) {
		std::vector<MicroTacticsModel*> tanks = squadTactics->getSubTeam(UnitTypes::Terran_Siege_Tank_Siege_Mode);
		if(!tanks.empty()) {
			Position tankLine;

			int avgX = 0;
			int avgY = 0;
			int siegedTanks = 0;
			// find where the tanks are
			for(unsigned int i = 0; i < tanks.size(); i++) {
				if(tanks.at(i)->getUnit()->isSieged()) {
					avgX = avgX + tanks.at(i)->getUnit()->getPosition().x();
					avgY = avgY + tanks.at(i)->getUnit()->getPosition().y();
					siegedTanks++;
				}
			}
			//if(siegedTanks == 0) {

			//} else {
			// find the average position
			if(siegedTanks != 0) {
				avgX = avgX/siegedTanks;
				avgY = avgY/siegedTanks;
				tankLine = Position(avgX, avgY);

				// now... we might already be AT the tank line
				// in which case, we just want to shoot stuff...
				// but if we're far away, lets move towards it
				if(element->getPosition().getDistance(tankLine) > 150) {
					if(!element->isMoving()) {
						element->attack(tankLine);
					}
					return true;
				} else {
					if(nearByEnemies > 0) {
						if(element->getGroundWeaponCooldown() <= 0) {
							if(closestEnemy->getHitPoints() > 0) {
								element->attack(closestEnemy);
								return true;
							}
						}
					} else {
						if(element->getPosition().getDistance(Position(tankLine)) > 100) {
							move(tankLine);
							return true;
						}
					}
				}
			}

		}
	}

	
	if(nearByEnemies != 0 && closestEnemy != NULL) {
		// shoot stuff!    
		if(element->getGroundWeaponCooldown() <= 0) {
				if(element->getDistance(closestEnemy) > 96 || (element->getOrderTarget() != NULL && element->getOrderTarget()->getType().isBuilding())) {
					element->attack(closestEnemy);
					retreating = false;
					return true;
				}
			} else {
				if(element->getOrderTarget() != NULL && !element->getOrderTarget()->getType().isBuilding() &&  !element->getOrderTarget()->getType().isWorker()) {
					int tx = element->getOrderTarget()->getPosition().x();
					int ty = element->getOrderTarget()->getPosition().y();
					int mx = element->getPosition().x();
					int my = element->getPosition().y();

					int nx = 0;
					int ny = 0;

					// if the enemy is to my right
					if(tx >= mx) {
						// move far left
						nx = (tx-350);
					} else {
						// move far right
						nx = tx+350;
					}

					// if the enemy is below me
					if(ty >= my) {
						// move up
						ny = (ty-350);
					} else {
						// move down
						ny = (ty+350);
					}
					patrol(Position(nx,ny));
					retreating = true;
				}
			}

			lastTarget = closestEnemy;
			return true;
		}
	if(element->isPatrolling()) {
		element->stop();
	}
	return false;

		

	}

	Unit* VultureMicroTactics::getUnit() {
		return element;
	}

