#ifndef WRAITHHK_H
#define WRAITHHK_H
#include "MicroTacticsModel.h"
#include "UnitModel.h"
#include "ValkyrieAerialSquadron.h"

class ValkyrieHunterKillerTactics : public MicroTacticsModel {

public:
	ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u);
	ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u, ValkyrieAerialSquadron* p, InformationManagerAgent* a);
	ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	void setTarget(Unit* t);
	void clearTarget();
	void declareTarget();
	virtual void move(Position p);
	void attachIntelligenceModule(InformationManagerAgent* a);
		virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* squadTarget;
	Unit* myTarget;
	int myTargetFitness;
	Position nextPoint;
	ValkyrieAerialSquadron* parent;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	InformationManagerAgent* intelligenceModule;
	bool repairMode;
		UnitType knownType;
};


#endif