#include "ValkyrieHunterKillerTactics.h"
#include <cmath>
#include <ctime> 

ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	repairMode = false;
	knownType = u->getType();
}

ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u, ValkyrieAerialSquadron* p, InformationManagerAgent* a) {
	element = u;
	intelligenceModule = a;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	parent = p;
	myTargetFitness = 0;
	repairMode = false;
	knownType = u->getType();
}

UnitType ValkyrieHunterKillerTactics::getKnownType() {
	return knownType;
}

ValkyrieHunterKillerTactics::ValkyrieHunterKillerTactics(Unit* u, int movementLag) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	repairMode = false;
}


void ValkyrieHunterKillerTactics::setMovementLag(int l) {
	initialMovementLag = l;
}

void ValkyrieHunterKillerTactics::declareTarget() {
	//parent->receiveTarget(myTarget->getUnit(), myTargetFitness);
}

void ValkyrieHunterKillerTactics::move(Position p) {
	element->attack(p);
}

void ValkyrieHunterKillerTactics::setTarget(Unit* t) {
	squadTarget = t;
}

void ValkyrieHunterKillerTactics::clearTarget() {
	squadTarget = NULL;
}

bool ValkyrieHunterKillerTactics::executeTactics() {
	if(!element->isCompleted()) {
		return true;
	}

	if(element->getHitPoints() <= element->getType().maxHitPoints()*0.4 && !repairMode) {
		element->move(intelligenceModule->findHighestConcentrationOf(UnitTypes::Terran_SCV));
		repairMode = true;
		return true;
	}
	if(repairMode) {
		if(element->getHitPoints() == element->getType().maxHitPoints()) {
			repairMode = false;
		}
	}

	if(element->isUnderAttack()) {
		std::set<Unit*> stuffInRange = element->getUnitsInWeaponRange(element->getType().airWeapon());
		int numFlyers = 0;
		for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
		{
			if((*it)->getType().isFlyer() && (*it)->getType().canAttack()) {
				numFlyers++;
			}
		}
		if(numFlyers >= 2) {
			Position safeZone = intelligenceModule->findHighestConcentrationOf(UnitTypes::Terran_Missile_Turret);
		if(element->getDistance(safeZone) > UnitTypes::Terran_Missile_Turret.airWeapon().maxRange()) {
			element->move(safeZone);
			return true;
		}
		}
	}



	if(myTarget != NULL) {
		if(myTarget->getHitPoints() > 0) {
			if(element->isInWeaponRange(myTarget)) {
				//if(!element->isMoving()) {
				int tx = myTarget->getPosition().x();
				int ty = myTarget->getPosition().y();
				int mx = element->getPosition().x();
				int my = element->getPosition().y();

				int nx = 0;
				int ny = 0;

				// if the enemy is to my right
				if(tx >= mx) {
					// move far left
					nx = (tx-300);
				} else {
					// move far right
					nx = tx+300;
				}

				// if the enemy is below me
				if(ty >= my) {
					// move up
					ny = (ty-300);
				} else {
					// move down
					ny = (ty+300);
				}
				element->stop();
				element->move(Position(nx,ny));
				//element->patrol(Position(nx,ny));
			} else {
				element->attack(myTarget);
			}

			return true;
		}
		}
	
	//if(squadTarget == NULL) {

		std::set<BWAPI::Unit*> neighbours = element->getUnitsInRadius(element->getType().sightRange());
		Unit* bestTarget = NULL;
		int bestFitness = 0;
		int enemies = 0;
		if(!neighbours.empty()) {
			for (std::set<BWAPI::Unit*>::const_iterator it = neighbours.begin(); it != neighbours.end(); ++it)
			{
				if((*it)->getPlayer() != Broodwar->self() && (*it)->getType().isFlyer() && !(*it)->getType().isNeutral()) {
					enemies++;
					if(bestTarget == NULL) {
						bestTarget = *it;
						bestFitness = fitnessCalculator->calculateFitness(*it);
					}
					int curFitness = fitnessCalculator->calculateFitness(*it);
					if(curFitness > bestFitness) {
						bestTarget = *it;
						bestFitness = curFitness;
					}
				}
			}
			myTarget = bestTarget;
		} else {
			myTarget = NULL;
		}
	

	if(enemies != 0) {
		return true;
	} else {
		return false;
	}
}

Unit* ValkyrieHunterKillerTactics::getUnit() {
	return element;
}

void ValkyrieHunterKillerTactics::attachIntelligenceModule(InformationManagerAgent* a) {
	intelligenceModule = a;
}