#include "ValkyrieAerialSquadron.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "ValkyrieHunterKillerTactics.h"

ValkyrieAerialSquadron::ValkyrieAerialSquadron(Squad* m, AgentPool* p) {
	dead = false;
	element = m;
	agentPool = p;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnitAt(i));
	}
	m->attachTacticsImplementation(this);
	intelligenceModule = (InformationManagerAgent*)agentPool->getAgent("EI");
	findNewPoint();
}

void ValkyrieAerialSquadron::assignUnit(Unit* u) {
	if(u->getType() == BWAPI::UnitTypes::Terran_Valkyrie) {
		unitTactics.push_back(new ValkyrieHunterKillerTactics(u, this, (InformationManagerAgent*)agentPool->getAgent("EI")));
	}	
}


void ValkyrieAerialSquadron::findNewPoint() {
		//////agentPool->writeDebugMessage("looking for a new point");
		InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!im->getBases().empty()) {
		nextPoint= im->getBases().at(rand()%im->getBases().size())->getPosition();
		int newX = rand()%768;
		int newY = rand()%768;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;	
		nextPoint = Position(nextPoint.x()+newX, nextPoint.y()+newY).makeValid();
		////////agentPool->writeDebugMessage("lheading to...");
		////////agentPool->writeDebugMessage(nextPoint.x());
		////////agentPool->writeDebugMessage(nextPoint.y());

	}
}


//void ValkyrieAerialSquadron::receiveTarget(Unit* u, int f) {
//	std::pair<int, Unit*> newTarget;
//	newTarget.first = f;
//	newTarget.second = u;
//	squadTargets.push_back(newTarget);
//}

void ValkyrieAerialSquadron::broadcastTarget() {
	Unit* bestTarget = NULL;
	int bestFitness = 9000;

	if(!squadTargets.empty()) {
		for(unsigned int i = 0; i < squadTargets.size(); i++) {
			if(squadTargets.at(i).first < bestFitness && squadTargets.at(i).second->getHitPoints() > 0) {
				bestFitness = squadTargets.at(i).first;
				bestTarget = squadTargets.at(i).second;
			}
		}
		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			ValkyrieHunterKillerTactics* u = (ValkyrieHunterKillerTactics*)unitTactics.at(i);
			u->setTarget(bestTarget);
		}
		squadTargets.clear();
	}
}

void ValkyrieAerialSquadron::receiveAlert(Unit* t) {
	assignUnit(t);
}

std::vector<MicroTacticsModel*> ValkyrieAerialSquadron::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit()->getType() == t) {
			subSquad.push_back(u);
		}	
	}
	return subSquad;
}

bool ValkyrieAerialSquadron::execute() {
	// since this squad can have units that haven't yet finished training, we
	// need to ignore those
	////////agentPool->writeDebugMessage("executing air squadron tactics");
	


	int unitsAtWayPoint = 0;
	int livingUnits = 0;
	bool microTacticsExecuted = false;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		
		MicroTacticsModel* m = unitTactics.at(i);

		// ignore units under construction 
		if(!m->getUnit()->isCompleted()) {
			continue;
		}

		// firstly, if this guy is dead, get rid of him
		if(m->getUnit()->getHitPoints() <= 0) {
			//////agentPool->writeDebugMessage("guy is dead");
			//unitTactics.erase(unitTactics.begin()+i);

			// and if this tactical squad has been wiped out, get rid of it
			//if(unitTactics.empty()) {
			//	dead = true;
			//	return false;
			//}
			
			continue;
		} else {
			livingUnits++;
		}
		if(m->getUnit()->getDistance(nextPoint) < 200) {
			unitsAtWayPoint++;
		}
		//////agentPool->writeDebugMessage("seeing which tactics to do...");
	//	broadcastTarget();
		if(m->executeTactics() == true) {
			// if the micro tactic did something, we're cool
			//////agentPool->writeDebugMessage("micro tactics executed!");
			microTacticsExecuted = true;
			continue;
		} else {
			//////agentPool->writeDebugMessage("trying to do macro!");
			int alive = 0;
			for(unsigned int j = 0; j < unitTactics.size(); j++) {
				MicroTacticsModel* k = unitTactics.at(j);
				if(k->getUnit()->isCompleted()) {
					if(k->getUnit()->getHitPoints() > 0) {
						alive++;
					}
				}
			}
			if(alive >= 2) {
					//////agentPool->writeDebugMessage("moving!");
				m->move(nextPoint);
			}
		}
	}


	if(unitsAtWayPoint >= livingUnits*0.8){
		//	//////agentPool->writeDebugMessage("finding new point!");
		findNewPoint();
	}

	return true;
}

void ValkyrieAerialSquadron::removeUnit( Unit* u )
{

}
