#ifndef UnitModel_H
#define UnitModel_H
#include <BWAPI.h>
#include <BWTA.h>
using namespace BWAPI;
using namespace BWTA;

class UnitModel {
public:
	UnitModel::UnitModel(UnitType t);
	UnitModel::UnitModel(Unit* m);
	UnitModel::UnitModel();

	void UnitModel::assignUnit(Unit* u);

	Unit* UnitModel::getUnit();
	UnitType UnitModel::getUnitType();

	Region* UnitModel::getRegion();
	void UnitModel::setRegion(Region* r);

	bool UnitModel::unitIsKnown();
	bool UnitModel::typeIsKnown();
	bool UnitModel::regionIsKnown();
	bool UnitModel::isAlive();
	void UnitModel::dead();

	Position UnitModel::getLastKnownPosition();
	void UnitModel::setLastKnownPosition(Position n);

	
private:
	Unit* element;
	UnitType type;
	Position lastKnownPosition;
	bool unitKnown;
	bool typeKnown;
	bool regionKnown;
	bool alive;
	Region* region;
	Position* target;
};
#endif