#include "UnitModel.h"


// might have seen the unit itself
UnitModel::UnitModel(Unit* m) {
	unitKnown = true;
	typeKnown = true;
	element = m;
	type = m->getType();
	lastKnownPosition = m->getPosition();
	regionKnown = false;
	alive = true;
}

// might infer that the unit exists, but we don't know where yet
UnitModel::UnitModel(UnitType t) {
	unitKnown = false;
	typeKnown = true;
	regionKnown = false;
	type = t;
	alive = true;
}

bool UnitModel::regionIsKnown() {
	return regionKnown;
}


bool UnitModel::isAlive() {
	if(unitIsKnown()) {
		if(element->isVisible()) {
			if(element->getHitPoints() > 0) {
				lastKnownPosition = element->getPosition(); // might as well sneak this in here
				alive = true;
			} else {
				alive = false;
			}
		} else {
			if(element->getPlayer() == Broodwar->self()) {
				alive = element->getHitPoints() > 0;
			} 
		}
	}
	return alive;
}

void UnitModel::dead() {
	alive = false;
}

void UnitModel::assignUnit(Unit* u) {
	element = u;
	unitKnown = true;
	typeKnown = true;
	regionKnown = true;
	region = BWTA::getRegion(u->getTilePosition());
	type = u->getType(); 
	lastKnownPosition = u->getPosition();
}

Unit* UnitModel::getUnit() {
	return element;
}
UnitType UnitModel::getUnitType() {
	return type;
}
Region* UnitModel::getRegion() {
	return region;
}
void UnitModel::setRegion(Region* r) {
	region = r;
}
bool UnitModel::unitIsKnown() {
	return unitKnown;
}
bool UnitModel::typeIsKnown() {
	return typeKnown;
}
Position UnitModel::getLastKnownPosition() {
	return lastKnownPosition;
}
void UnitModel::setLastKnownPosition(Position n) {
	lastKnownPosition = n;
}