#include "TrainingManagerAgent.h"
#include "AgentPool.h"

TrainingManagerAgent::TrainingManagerAgent(AgentPool* p) {
	agentPool = p;
}

TrainingManagerAgent::TrainingManagerAgent() {

}


void TrainingManagerAgent::updateDrives() {
}

// consider that this might be called constantly, thus suck
bool TrainingManagerAgent::canBeTrained(BWAPI::UnitType req) {
	//////////////agentPool->writeDebugMessage("looking to see if I can train: ");
	//////////////agentPool->writeDebugMessage(req.getName());
	bool trainerFound = false;
	std::map<UnitType, int> preReqs = req.requiredUnits();
	unsigned int numSatisfied = 0;

	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->isCompleted()) {
		if((*i)->getType() == req.whatBuilds().first) {
			if(!trainerFound) {
				trainerFound = ((Broodwar->self()->supplyUsed())+(req.supplyRequired()) <= Broodwar->self()->supplyTotal()) && !(*i)->isTraining() && !(*i)->isConstructing() && Broodwar->self()->minerals() >= req.mineralPrice() && Broodwar->self()->gas() >= req.gasPrice();
			}
		}
		}
		for(std::map<UnitType,int>::const_iterator it = preReqs.begin(); it != preReqs.end(); it++) {
			if((*it).first == (*i)->getType()) {
				numSatisfied++;
			}
		}
	}
	//////agentPool->writeDebugMessage("prereqs size:");
	//////agentPool->writeDebugMessage((int)preReqs.size());
	//////agentPool->writeDebugMessage("we have: ");
	//////agentPool->writeDebugMessage((int)numSatisfied);

	return trainerFound == true && numSatisfied >= preReqs.size();
}

// this is probably a bad idea. we probably need to keep all of our unit somewhere
// anyway, so might refer to that in the future?
Unit* TrainingManagerAgent::trainUnit(BWAPI::UnitType req) {
	Unit* primary =  NULL;
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType() == req.whatBuilds().first && (*i)->isCompleted() && !(*i)->isTraining() && !(*i)->isConstructing()) {
			if(req == UnitTypes::Terran_Marine || req == UnitTypes::Terran_Firebat) {
				std::vector<Position> points;
				for(unsigned int k = 0; k < 256; k++) {
					int newX = rand()%450;
					int newY = rand()%750;
					
					if(rand()%100 >= 50) newX = -newX;
					if(rand()%100 >= 50) newY = -newY;
					Position p = Position((*i)->getPosition().x()+newX, (*i)->getPosition().y()+newY).makeValid();
					//if(!Broodwar->isExplored((TilePosition)p)) {
					points.push_back(BWTA::getRegion((TilePosition)((*i)->getPosition()))->getPolygon().getNearestPoint(p));

					//}
				}
				if(!points.empty()){
				(*i)->setRallyPoint(points.at(rand()%(points.size()-1)));
				}
			
			}
			if(req == UnitTypes::Terran_Siege_Tank_Tank_Mode || req == UnitTypes::Terran_Valkyrie || req == UnitTypes::Terran_Battlecruiser) {
				if((*i)->getAddon() != NULL) {
					if((*i)->train(req)) {
						primary = *i;
					} else {
						primary = NULL;
					}
					
					
				}
			} else {
				if((*i)->train(req)) {
					primary = *i;
				} else {
					primary = NULL;
				}
			}
		}
	}
	return primary;
}

Unit* TrainingManagerAgent::trainUnit(BWAPI::UnitType req, Position nearhere) {
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType() == req.whatBuilds().first && (*i)->getDistance(nearhere) < 500) {
			if((*i)->isCompleted() && !(*i)->isTraining() && !(*i)->isConstructing()) {
			(*i)->train(req);
			//////////////////////////agentPool->writeDebugMessage("training!");
			return *i;
			}
		}
	}
	return NULL;
}

