#ifndef THREATAWAREPATHFINDER_H
#define THREATAWAREPATHFINDER_H
#include "InformationManagerAgent.h"
#include "UnitModel.h"
#include "BWAPI.h"
#include "BWTA.h"
#include <windows.h>
using namespace BWAPI;
using namespace BWTA;

class MapNode
{
public:

	MapNode *parent; 
	MapNode *child; 

	float g; 
	int h; 
	int f; 
	TilePosition p;

	MapNode() :
	parent( 0 ),
		child( 0 ),
		g( 900.0 ),
		h( 0 ),
		f( 0 )
	{			
	}
	MapNode(TilePosition s) :
	parent( 0 ),
		child( 0 ),
		g( 900.0 ),
		h( 0 ),
		f( 0 )
	{	
		p = TilePosition(s.x(),s.y());
	}
};


class AgentPool;

class ThreatAwarePathFinder {
 public:
	 ThreatAwarePathFinder::ThreatAwarePathFinder(InformationManagerAgent* im, AgentPool* p);
	 std::set<MapNode*> ThreatAwarePathFinder::getNeighbours(MapNode* p,  int precision);
	 std::set<MapNode*> ThreatAwarePathFinder::pathFind(TilePosition s, TilePosition g,  int precision);
	 std::set<MapNode*> ThreatAwarePathFinder::gaussianPathFind(TilePosition s, TilePosition g,  int precision);

	 bool ThreatAwarePathFinder::contains(std::set<MapNode*> s, MapNode* g);
	 bool ThreatAwarePathFinder::remove(std::set<MapNode*> s, MapNode* g);
	 MapNode* ThreatAwarePathFinder::best(std::set<MapNode*> s);
	 void ThreatAwarePathFinder::drawGrid();
	 std::vector<MapNode*> path;
	 bool pathFound;
	 bool findingPath;
private:
	InformationManagerAgent* informationManager;
	AgentPool* agentPool;
	MapNode* map[256][256];
	std::set<MapNode*> population;

};








#endif
