#include "ThreatAwarePathfinder.h"
#include "AgentPool.h"

ThreatAwarePathFinder::ThreatAwarePathFinder(InformationManagerAgent* im, AgentPool* p) {
	informationManager = im;
	agentPool = p;
	for(int i = 0; i < Broodwar->mapWidth(); i++) {
		for(int j = 0; j < Broodwar->mapHeight(); j++) {
			map[i][j] = new MapNode(TilePosition(i,j));
		}
	}
	pathFound = false;
	findingPath = false;

	for(unsigned int i = 0; i < 12; i++) {
		int	newX = rand()%Broodwar->mapWidth();
		int newY = rand()%Broodwar->mapHeight();
		MapNode* m = new MapNode(TilePosition(newX,newY).makeValid());
		while(!Broodwar->isWalkable(m->p.x()*4, m->p.y()*4) && !Broodwar->isBuildable(m->p)) {
				newX = rand()%Broodwar->mapWidth();;
			 newY = rand()%Broodwar->mapHeight();
			m = new MapNode(TilePosition(newX,newY).makeValid());
		}
		population.insert(m);
	}


}

std::set<MapNode*> ThreatAwarePathFinder::gaussianPathFind(TilePosition s, TilePosition g,  int precision) {
	std::set<MapNode*> empty;
	return empty;
}


void ThreatAwarePathFinder::drawGrid() {
	//for(unsigned int i = 0; i < 96; i++) {
	//	for(unsigned int j = 0; j < 128; j++) {
	//		TilePosition q = map[i][j]->p;
	//		Broodwar->drawBox(CoordinateType::Map,q.x()*32,q.y()*32,q.x()*32+4*8,q.y()*32+2*8,Colors::Green,false);
	//	}
	//}
	//for(std::set<MapNode*>::const_iterator i = population.begin(); i != population.end(); i++) {
	//	TilePosition q = (*i)->p;
		//Broodwar->drawBox(CoordinateType::Map,q.x()*32,q.y()*32,q.x()*32+4*8,q.y()*32+2*8,Colors::Green,false);
//	}

}

std::set<MapNode*> ThreatAwarePathFinder::getNeighbours(MapNode* n,  int precision) {
	
	std::set<MapNode*> nbrs;
	int offset = precision;

	for(std::set<MapNode*>::const_iterator i = population.begin(); i != population.end(); i++) {
	if(n->p != (*i)->p) { 
			if(n->p.getDistance((*i)->p) <= precision) {
			std::vector<TilePosition> p = BWTA::getShortestPath(n->p, (*i)->p);

			if(p.size() < 5) {
			nbrs.insert((*i));
			}
			}
		}
	}


	/*
	////////////agentPool->writeDebugMessage("considering");
	////////////agentPool->writeDebugMessage(n->p.x());
	////////////agentPool->writeDebugMessage((n->p.y()));
	// left
	if(n->p.x()-precision >= 0) {
		////////////agentPool->writeDebugMessage(("left neighbour"));
		nbrs.push_back(map[n->p.x()-precision][n->p.y()]);
	}

	// right
	if(n->p.x()+precision <= 96) {
		////////////agentPool->writeDebugMessage(("right neighbour"));
		nbrs.push_back(map[n->p.x()+precision][n->p.y()]);
	}

	// down
	if(n->p.y()+precision <= 128) {
		////////////agentPool->writeDebugMessage(("down neighbour"));
		nbrs.push_back(map[n->p.x()][n->p.y()+precision]);
	}

	// up
	if(n->p.y()-precision >= 0) {
		////////////agentPool->writeDebugMessage(("up neighbour"));
		nbrs.push_back(map[n->p.x()][n->p.y()-precision]);
	}
	
	// up left
	if(n->p.y()-precision <= 128 && n->p.x()-precision >= 0) {
		////////////////////agentPool->writeDebugMessage(("up neighbour"));
		nbrs.push_back(map[n->p.x()-precision][n->p.y()-precision]);
	}

	// up right
	if(n->p.y()+precision <= 128 && n->p.x()+precision <= 96) {
		////////////////////agentPool->writeDebugMessage(("up neighbour"));
		nbrs.push_back(map[n->p.x()+precision][n->p.y()+precision]);
	}

	// down left
	if(n->p.y()+precision >= 0 && n->p.x()-precision >= 0) {
		////////////////////agentPool->writeDebugMessage(("up neighbour"));
		nbrs.push_back(map[n->p.x()-precision][n->p.y()+precision]);
	}
	// up right
	if(n->p.y()-precision >= 0 && n->p.x()+precision <= 96) {
		////////////////////agentPool->writeDebugMessage(("up neighbour"));
		nbrs.push_back(map[n->p.x()+precision][n->p.y()-precision]);
	}
	*/


	return nbrs;
}

bool ThreatAwarePathFinder::contains(std::set<MapNode*> s, MapNode* g) {
	for(std::set<MapNode*>::const_iterator i = s.begin(); i != s.end(); i++) {
		if((*i)->p.x() == g->p.x() && (*i)->p.y() == g->p.y()) {
			////////////////////agentPool->writeDebugMessage("yep!");
			return true;
		}
	}
	 ////////////////////agentPool->writeDebugMessage("nope!");
	return false;
}

bool ThreatAwarePathFinder::remove(std::set<MapNode*> s, MapNode* g) {
	for(std::set<MapNode*>::const_iterator i = s.begin(); i != s.end(); i++) {
		if((*i)->p.x() == g->p.x() && (*i)->p.y() == g->p.y()) {
			s.erase(*i);
			break;
		}
	}
	return false;

}

MapNode* ThreatAwarePathFinder::best(std::set<MapNode*> s) {
	MapNode* bestSoFar;
	int bestGSoFar = 1233344000000;
	for(std::set<MapNode*>::const_iterator i = s.begin(); i != s.end(); i++) {
		if((*i)->g < bestGSoFar) {
			bestGSoFar = (*i)->g;
			bestSoFar = (*i);
		}
	}
	return bestSoFar;

}

struct nodeComp {
	bool operator()(MapNode* a, MapNode* b) const{
		return (a->g < b->g);
	}

} nodeComp_;



std::set<MapNode*> ThreatAwarePathFinder::pathFind(TilePosition s, TilePosition g, int precision) {
	std::set<MapNode*, nodeComp> open;
	std::set<MapNode*, nodeComp> closed;
	////////////agentPool->writeDebugMessage("begin");
	////////////agentPool->writeDebugMessage(s.x());
	////////////agentPool->writeDebugMessage(s.y());
	/*
	// clamp goal
	int clamp = 10;
	int cx = 0;
	int cy = 0;
	if(g.x() > s.x() && abs(g.x()-s.x()) > clamp) {
		cx = clamp;
	}
	if(g.x() < s.x() && abs(g.x()-s.x()) > clamp) {
		cx = -clamp;
	}
	if(g.y() > s.y() && abs(g.y()-s.y()) > clamp) {
		cy = clamp;
	}
	if(g.y() < s.y() && abs(g.y()-s.y()) > clamp) {
		cy = -clamp;
	}

	if(cx == 0) {
		cx = g.x();
	} else {
		cx = s.x()+cx;
	}

	if(cy == 0) {
		cy = g.y();
	} else {
		cy = s.y()+cy;
	}
	*/
	//	MapNode* end = map[s.x()+cx][s.y()+cx];
	MapNode* end = map[g.x()][g.y()];


	bool running = true;
	////////////agentPool->writeDebugMessage("starting");
	bool firstRun = true;

	while(running) {
		////////////agentPool->writeDebugMessage("waf");
		
		MapNode* current;
			if(firstRun) {
				current = map[s.x()][s.y()];
				firstRun = false;
			} else { 
				//std::sort(open.begin(), open.end(), nodeComp_);
				//current = best(open);
				current = *open.begin();
			}

		////////////agentPool->writeDebugMessage("best");
		////////////agentPool->writeDebugMessage(current->p.x());
		////////////agentPool->writeDebugMessage(current->p.y());
		////////////agentPool->writeDebugMessage("wa");
		if(current->p.getDistance(g) <= 16) {
			////////////agentPool->writeDebugMessage("found the goal!");
			end = current;
			running = false;
		}

		std::set<MapNode*> currentNeighbours = getNeighbours(map[current->p.x()][current->p.y()], precision);
		////////////agentPool->writeDebugMessage("wadddf");
		closed.insert(current);
		open.erase(current);
		////////////agentPool->writeDebugMessage("waddf");

		////////////agentPool->writeDebugMessage("nbrs done");
		if(!currentNeighbours.empty()) {
	for(std::set<MapNode*>::const_iterator i = currentNeighbours.begin(); i != currentNeighbours.end(); i++) {
			////////////agentPool->writeDebugMessage("nbr at:");
			////////////agentPool->writeDebugMessage((*i)->p.x());
			////////////agentPool->writeDebugMessage((*i)->p.y());
			MapNode* currentNeighbour = (*i);

			//if(Broodwar->isBuildable(currentNeighbour->p)){

			//	int cost = g.getDistance(currentNeighbour->p);
			int cost = 10*(abs(currentNeighbour->p.x()-g.x())+abs(currentNeighbour->p.y()-g.y()));

			////////////agentPool->writeDebugMessage("cost: ");
			////////////agentPool->writeDebugMessage(cost);

	
			if(count(open.begin(), open.end(), currentNeighbour) > 0 && cost < currentNeighbour->g) {
				open.erase(currentNeighbour);
			} 

			if(count(closed.begin(), closed.end(), currentNeighbour) > 0 && cost < currentNeighbour->g) {
				closed.erase(currentNeighbour);
			} 

			if(count(open.begin(), open.end(), currentNeighbour) == 0 && count(closed.begin(), closed.end(), currentNeighbour) == 0) {
				////////////////////agentPool->writeDebugMessage("yaaay");
				currentNeighbour->g = cost;
				currentNeighbour->parent = current;
				open.insert(currentNeighbour);
				////////////////////agentPool->writeDebugMessage("woo");
			}
			//}

		}
		}
		////////////agentPool->writeDebugMessage("dep");
	}
	////////////agentPool->writeDebugMessage("openlist is: ");
	////////////agentPool->writeDebugMessage((int)open.size());


	std::set<MapNode*> path;
	MapNode* e = end;
	path.insert(e);
	while(e != NULL) {
		path.insert(e);
		e = e->parent;
	}


	return path;


}



