#ifndef TELEPORTERUSERS_H
#define TELEPORTERUSERS_H
#include "TacticsImplementations.h"
#include <map>
#include <list>

class TeleporterUsers : public TacticsImplementation {
public:
	TeleporterUsers(Squad* m, AgentPool* p);
	virtual bool execute();
	virtual std::vector<MicroTacticsModel*> getSubTeam(UnitType t);
	virtual void receiveAlert(Unit* t);
	virtual void assignUnit(Unit* u);
	virtual void removeUnit(Unit* u);
private:
	AgentPool* agentPool;
	Squad* element;
	bool dead;
	std::map<Unit*, Unit*> teleporterPerception;
	std::map<Unit*, std::list<Unit*>> teleporterQueue;
	bool teleportersOnMap;
};

#endif