#include "TeleporterUsers.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "DropShipMicroTactics.h"
#include "SquadManagerAgent.h"

TeleporterUsers::TeleporterUsers(Squad* m, AgentPool* p) {
	dead = false;
	element = m;
	agentPool = p;
	if(!element->getUnits().empty()) {
		for(unsigned int i = 0; i < element->getUnits().size(); i++) {
			assignUnit(element->getUnitAt(i));
		}
	}
	m->attachTacticsImplementation(this);
	if(Broodwar->mapFileName().compare("(4)Fortress.scx") == 0) {
		////Broodwar->sendText("------- TELEPORTERS ON MAP --------");
		teleportersOnMap = true;
	} else {
		////Broodwar->sendText("------- NOOOOOO TELEPORTERS ON MAP --------");
		teleportersOnMap = false;
	}

}

void TeleporterUsers::assignUnit(Unit* u) {
	element->forceUnit(u);
}


void TeleporterUsers::receiveAlert(Unit* t) {
	assignUnit(t);
}

std::vector<MicroTacticsModel*> TeleporterUsers::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	return subSquad;
}

bool TeleporterUsers::execute() {
	if(!teleportersOnMap) {
		return true;
	}
	std::vector<Unit*> units =  element->getLivingUnits();
	if(!units.empty()) {

		// units
		for(std::vector<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
			Unit* currentUnit = *i;

			if(currentUnit->getTargetPosition() == Positions::None || currentUnit->isGatheringGas() || currentUnit->isGatheringMinerals() || currentUnit->isAttacking()) {
				continue;
			}

			Position bTarget = currentUnit->getTargetPosition();
			std::set<Unit*> s = currentUnit->getUnitsInRadius(300);
			int enemies = 0;
			if(Broodwar->getFrameCount()%256==0) {
				teleporterQueue[currentUnit].clear();
				// teleporters
				for(std::set<Unit*>::const_iterator i = s.begin(); i != s.end(); i++) {
					Unit* cur = *i;
					if(cur->getType().isMineralField()) {
						if(cur->getResources() > 200 && cur->getResources() <= 250) {
							if(currentUnit->getDistance(bTarget) > cur->getDistance(bTarget)) {
								teleporterQueue[currentUnit].push_back(cur);
							}
						}

					}
				}
				
				if(!teleporterQueue[currentUnit].empty()) {
					if(teleporterQueue[currentUnit].back()->getDistance(currentUnit) < teleporterQueue[currentUnit].front()->getDistance(currentUnit)) {
						std::swap(teleporterQueue[currentUnit].back(), teleporterQueue[currentUnit].front());
					}
				}
			} 
			
			if(Broodwar->getFrameCount()%64==0) {
				if(!teleporterQueue[currentUnit].empty()) {
					if(!currentUnit->getDistance(bTarget) < teleporterQueue[currentUnit].back()->getDistance(bTarget)) {
						currentUnit->rightClick(teleporterQueue[currentUnit].back());
						currentUnit->stop(true);
						teleporterQueue[currentUnit].pop_back();
					}
				}
			}
			


		}
	}







	return true;
}

void TeleporterUsers::removeUnit( Unit* u )
{

}
