#include "TargetFitnessCalculator.h"
#include "InformationManagerAgent.h"
#include "BaseModel.h"

TargetFitnessCalculator::TargetFitnessCalculator() {

}

int TargetFitnessCalculator::calculateAirFitness(Unit* target) {
	// 
	int fitness = 1000;
	//std::set<BWAPI::Unit*> neighbours = target->getUnitsInRadius(target->getType().sightRange()/2.0);
	//for (std::set<BWAPI::Unit*>::const_iterator it = neighbours.begin(); it != neighbours.end(); ++it)
	//{
	Unit* u = target;

	// ignore junk that can't hurt us
	if((u->getType().isBuilding() && u->getType() != UnitTypes::Zerg_Sunken_Colony) || u->getType().isNeutral() || u->getType().isSpecialBuilding() || u->getType().isAddon() || !u->getType().canAttack()) {
		fitness+=650;
	}

	// so now we have the defensive score
	// what is this target worth?


	// we like to kill workers
	if(target->getType().isWorker()) {
		fitness-=150;
		// especially if they're constructing something!
		if(target->isConstructing()) {
			fitness-=50;
		}
		if(target->isGatheringGas() || target->isGatheringMinerals()) {
			fitness-=25;
		}
	}
	if(target->getType() == UnitTypes::Zerg_Overlord) {
		fitness-=650;
	}
	if(target->getType() == UnitTypes::Zerg_Guardian) {
		fitness-=350;
	}
	if(target->getType() == UnitTypes::Terran_Medic) {
		fitness-=300;
	}
	if(target->getType() == UnitTypes::Terran_Dropship) {
		fitness-=100;
	}
	if(target->getType() == UnitTypes::Protoss_Shuttle) {
		fitness-=100;
	}
	if(target->getType() == UnitTypes::Protoss_High_Templar) {
		fitness-=625;
	}
	if(target->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode) {
		fitness-=600;
	}
	if(target->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		fitness-=400;
	}
	if(target->getType() == UnitTypes::Protoss_Arbiter) {
		fitness-=600;
	}
	if(target->getType() == UnitTypes::Protoss_Corsair) {
		fitness-=600;
	}
	if(target->getType() == UnitTypes::Zerg_Defiler) {
		fitness-=600;
	}
	if(target->getType() == UnitTypes::Protoss_Dark_Templar) {
		fitness-=300;
	}
	if(target->getType() == UnitTypes::Zerg_Sunken_Colony) {
		fitness-=200;
	}
	// also prefer stuff that can't hit us back, if we're a flying unit!
	if(target->getType().airWeapon() == WeaponTypes::None) {
		fitness-=250;
	}

	int targetHP = target->getHitPoints();
	int targetMaxHp = target->getType().maxHitPoints();
	if(targetHP <= (targetMaxHp/4)*1) {
		fitness -= 200;
	}

	// somewhat prefer targets at around half health
	if(targetHP <= (targetMaxHp/4)*2 && targetHP > (targetMaxHp/4)*1) {
		fitness -= 135;
	}

	// somewhat prefer targets at around mid health
	if(targetHP < (targetMaxHp/4)*3 && targetHP > (targetMaxHp/4)*2) {
		fitness -= 75;
	}

	// if there's no one else to pick, choose guys at close to full health
	if(targetHP >= (targetMaxHp/4)*3) {
		fitness -= 50;
	}

	//}
	return fitness;
}


int TargetFitnessCalculator::calculateFitness(Unit* target) {
	int fitness = 0;

	int targetHP = target->getHitPoints();
	int targetMaxHp = target->getType().maxHitPoints();

	int targetShields = target->getShields();
	int targetMaxShields = target->getType().maxShields();

	bool hasShields = false;

	// preferred enemies
	if(target->getType() == UnitTypes::Zerg_Lurker){
		fitness+=500;
	}
	if(target->getType() == UnitTypes::Zerg_Mutalisk){
		fitness+=300;
	}
	if(target->getType() == UnitTypes::Zerg_Hydralisk){
		fitness+=500;
	}
	if(target->getType() == UnitTypes::Zerg_Defiler){
		fitness+=500;
	}
	if(target->getType() == UnitTypes::Protoss_High_Templar){
		fitness+=500;
	}


	if(targetMaxShields > 0) {
		hasShields = true;
	}



	if(target->getType().canAttack()){
		fitness+=300;
	}

	/*

	Priority for buildings

	*/
	if(target->getType().isBuilding() ) {
		if(target->getType().canAttack()) {
			fitness+=25;
		} else {
			fitness-=200;
		}
	}

	// stuff we just want to ignore unless there is literally nothing else to kill
	// at which point we've probably won the game anyway!
	if(target->getType() == UnitTypes::Zerg_Larva || target->getType() == UnitTypes::Zerg_Egg) {
		fitness-=3000;
	}


	// first critera: is the target in weapons range? if so, we prefer things we can hit right now


	// now, how much HP does this guy have? we prefer guys with low HP

	// vastly prefer targets that are almost dead
	if(targetHP <= (targetMaxHp/4)*1) {
		fitness += 200;
	}

	// somewhat prefer targets at around half health
	if(targetHP <= (targetMaxHp/4)*2 && targetHP > (targetMaxHp/4)*1) {
		fitness += 100;
	}

	// somewhat prefer targets at around mid health
	if(targetHP < (targetMaxHp/4)*3 && targetHP > (targetMaxHp/4)*2) {
		fitness += 50;
	}

	// if there's no one else to pick, choose guys at close to full health
	if(targetHP >= (targetMaxHp/4)*3) {
		fitness += 25;
	}


	// now do exactly the same thing for units that have shields
	if(hasShields) {
		// firstly, if the shields are down, greatly prefer these units
		if(targetShields <= 0) {
			fitness+=200;
		}

		if(targetShields <= (targetMaxShields/4)*1) {
			fitness += 175;
		}

		// somewhat prefer targets at around half health
		if(targetShields <= (targetMaxShields/4)*2 && targetShields > (targetMaxShields/4)*1) {
			fitness += 75;
		}

		// somewhat prefer targets at around mid health
		if(targetShields < (targetMaxShields/4)*3 && targetShields > (targetMaxShields/4)*2) {
			fitness += 50;
		}

		// if there's no one else to pick, choose guys at close to full health
		if(targetShields >= (targetMaxShields/4)*3) {
			fitness += 25;
		}
	}



	return fitness;
}

int TargetFitnessCalculator::calculateMechFitness(Unit* target) {
	int fitness = 0;

	int targetHP = target->getHitPoints();
	int targetMaxHp = target->getType().maxHitPoints();

	int targetShields = target->getShields();
	int targetMaxShields = target->getType().maxShields();

	bool hasShields = false;


	// preferred enemies
	if(target->getType() == UnitTypes::Zerg_Mutalisk){
		fitness+=800;
	}
	if(target->getType() == UnitTypes::Zerg_Hydralisk){
		fitness+=500;
	}
	if(target->getType() == UnitTypes::Zerg_Guardian){
		fitness+=500;
	}
	if(target->getType() == UnitTypes::Zerg_Defiler){
		fitness+=200;
	}
	if(target->getType() == UnitTypes::Protoss_High_Templar){
		fitness+=600;
	}
	if(target->getType() == UnitTypes::Protoss_Corsair){
		fitness+=600;
	}
	if(target->getType() == UnitTypes::Protoss_Reaver){
		fitness+=600;
	}
	if(target->getType() == UnitTypes::Protoss_Arbiter){
		fitness+=600;
	}
	if(target->getType() == UnitTypes::Protoss_Zealot){
		fitness+=300;
	}
	if(target->getType() == UnitTypes::Protoss_Dragoon){
		fitness+=200;
	}
	if(target->getType() == UnitTypes::Protoss_Pylon){
		fitness+=200;
	}
	if(target->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode){
		fitness+=300;
	}
	if(targetMaxShields > 0) {
		hasShields = true;
	}

	if(target->getType().canAttack()){
		fitness+=300;
	}
	/*
	Priority for buildings
	*/
	if(target->getType().isBuilding() ) {
		if(target->getType().canAttack()) {
			fitness+=25;
		} else {
			fitness-=900;
		}
	}

	// stuff we just want to ignore unless there is literally nothing else to kill
	// at which point we've probably won the game anyway!
	if(target->getType() == UnitTypes::Zerg_Larva || target->getType() == UnitTypes::Zerg_Egg) {
		fitness-=3000;
	}



	// now, how much HP does this guy have? we prefer guys with low HP

	// vastly prefer targets that are almost dead
	if(targetHP <= (targetMaxHp/4)*1) {
		fitness += 200;
	}

	// somewhat prefer targets at around half health
	if(targetHP <= (targetMaxHp/4)*2 && targetHP > (targetMaxHp/4)*1) {
		fitness += 100;
	}

	// somewhat prefer targets at around mid health
	if(targetHP < (targetMaxHp/4)*3 && targetHP > (targetMaxHp/4)*2) {
		fitness += 50;
	}

	// if there's no one else to pick, choose guys at close to full health
	if(targetHP >= (targetMaxHp/4)*3) {
		fitness += 25;
	}


	// now do exactly the same thing for units that have shields
	if(hasShields) {
		// firstly, if the shields are down, greatly prefer these units
		if(targetShields <= 0) {
			fitness+=200;
		}

		if(targetShields <= (targetMaxShields/4)*1) {
			fitness += 175;
		}

		// somewhat prefer targets at around half health
		if(targetShields <= (targetMaxShields/4)*2 && targetShields > (targetMaxShields/4)*1) {
			fitness += 75;
		}

		// somewhat prefer targets at around mid health
		if(targetShields < (targetMaxShields/4)*3 && targetShields > (targetMaxShields/4)*2) {
			fitness += 50;
		}

		// if there's no one else to pick, choose guys at close to full health
		if(targetShields >= (targetMaxShields/4)*3) {
			fitness += 25;
		}
	}



	return fitness;

}

int TargetFitnessCalculator::calculateBaseFitness(BaseModel* bm, InformationManagerAgent* eim )
{
	std::vector<UnitModel*> buildings = eim->getKnownBuildingsAroundPoint(bm->getPosition(), 400);
	int buildingScore = 0;
	for(std::vector<UnitModel*>::const_iterator i = buildings.begin(); i != buildings.end(); i++) {
		UnitModel* cur = *i;
		if(cur->getUnitType() == Broodwar->enemy()->getRace().getCenter()) {
			buildingScore += 300;
		}
		if(cur->getUnitType() == UnitTypes::Protoss_Photon_Cannon || cur->getUnitType() == UnitTypes::Terran_Bunker || cur->getUnitType() == UnitTypes::Zerg_Sunken_Colony) {
			buildingScore -= 25;
		}
	}
	int unitScore = 0;
	std::vector<UnitModel*> units = eim->getKnownUnitsAroundPoint(bm->getPosition(), 400);		
	for(std::vector<UnitModel*>::const_iterator i = units.begin(); i != units.end(); i++) {
		UnitModel* cur = *i;
		// stuff we would, ideally, like to avoid!

		// walls of tanks
		if(cur->getUnitType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || cur->getUnitType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
			unitScore -= 10;
		}
		if(cur->getUnitType() == UnitTypes::Terran_Marine) {
			unitScore -= 2;
		}
		if(cur->getUnitType() == UnitTypes::Terran_Vulture) {
			unitScore -= 3;
		}
		if(cur->getUnitType() == UnitTypes::Zerg_Mutalisk) {
			unitScore -= 3;
		}
		if(cur->getUnitType() == UnitTypes::Zerg_Hydralisk) {
			unitScore -= 2;
		}
		if(cur->getUnitType() == UnitTypes::Zerg_Lurker) {
			unitScore -= 4;
		}
		if(cur->getUnitType() == UnitTypes::Protoss_Carrier) {
			unitScore -= 15;
		}
		if(cur->getUnitType() == UnitTypes::Protoss_Dark_Templar) {
			unitScore -= 4;
		}
		if(cur->getUnitType() == UnitTypes::Protoss_Archon) {
			unitScore -= 6;
		}
		if(cur->getUnitType() == UnitTypes::Protoss_Dragoon) {
			unitScore -= 3;
		}
	}

	return buildingScore + unitScore;

}
