#include "StrategyEstimator.h"


StrategyEstimator::StrategyEstimator() {




}

std::pair<int,int> StrategyEstimator::calculateUnitStrategyBias(std::vector<UnitModel*> knownUnits) {
	std::pair<int,int> total;
	total.first = 0;
	total.second = 0;
	for(unsigned int i = 0; i < knownUnits.size(); i++) {

		UnitModel* m = knownUnits.at(i);	

		if(m->unitIsKnown() && !m->getUnitType().isWorker()) {

			if(m->getUnit()->isCompleted() && m->getUnitType().canAttack()) {

				if(m->getUnitType().isFlyer()) {
					int supply = m->getUnitType().supplyRequired();
					if(supply != 0) {
						 total.first += (m->getUnitType().mineralPrice() + m->getUnitType().gasPrice())/supply; // air score
					}
				} else { 
					int supply = m->getUnitType().supplyRequired();
					if(supply != 0) {
						total.second += (m->getUnitType().mineralPrice() + m->getUnitType().gasPrice())/supply; // ground score
					}   
				}
			}
		}


	}
return total;

}



/*
So we want to assign a score to our opponent's current build. Or what we know
about their current build.

We wish to be able to determine if the opponent is currently following an
air-heavy strategy, or a ground-heavy strategy, or something inbetween.
*/
std::pair<int,int> StrategyEstimator::calculateBuildingStrategyBias(std::vector<UnitModel*> knownBuildings) {
	std::pair<int,int> total;
	total.first = 0;
	total.second = 0;

	for(unsigned int i = 0; i < knownBuildings.size(); i++) {
		UnitModel* m = knownBuildings.at(i);
		total.first += getAirScore(m->getUnitType());
		total.second += getGroundScore(m->getUnitType());
	}

	return total;

}

int StrategyEstimator::getGroundScore(UnitType u){
	int score = 0;
	if(u.getRace() == BWAPI::Races::Terran) {
		if(u == Terran_Barracks) score += (Terran_Barracks.mineralPrice() + Terran_Barracks.gasPrice());
		if(u == Terran_Factory) score += (Terran_Factory.mineralPrice() + Terran_Factory.gasPrice());
		if(u == Terran_Machine_Shop) score += (Terran_Machine_Shop.mineralPrice() + Terran_Machine_Shop.gasPrice());
		if(u == Terran_Armory) score += (Terran_Armory.mineralPrice() + Terran_Armory.gasPrice()); // dual-purpose
		if(u == Terran_Academy) score += (Terran_Academy.mineralPrice() + Terran_Academy.gasPrice());
		if(u == Terran_Engineering_Bay) score += (Terran_Engineering_Bay.mineralPrice() + Terran_Engineering_Bay.gasPrice());
		if(u == Terran_Covert_Ops) score += (Terran_Covert_Ops.mineralPrice() + Terran_Covert_Ops.gasPrice()); // doesn't really count
		if(u == Terran_Science_Facility) score += (Terran_Science_Facility.mineralPrice() + Terran_Science_Facility.gasPrice()); // iffy, usually accompanies ground units, as opposed to being used as air support?




		return score;
	}


	if(u.getRace() == BWAPI::Races::Zerg) {
		if(u == Zerg_Defiler_Mound) score += Zerg_Defiler_Mound.mineralPrice() + Zerg_Defiler_Mound.gasPrice();
		if(u == Zerg_Evolution_Chamber) score += Zerg_Evolution_Chamber.mineralPrice() + Zerg_Evolution_Chamber.gasPrice();
		if(u == Zerg_Hydralisk_Den) score += Zerg_Hydralisk_Den.mineralPrice() + Zerg_Hydralisk_Den.gasPrice();
		if(u == Zerg_Nydus_Canal) score += Zerg_Nydus_Canal.mineralPrice() + Zerg_Nydus_Canal.gasPrice();
		if(u == Zerg_Spawning_Pool) score += Zerg_Spawning_Pool.mineralPrice() + Zerg_Spawning_Pool.gasPrice();
		if(u == Zerg_Ultralisk_Cavern) score += Zerg_Ultralisk_Cavern.mineralPrice() + Zerg_Ultralisk_Cavern.gasPrice();
		return score;
	}


	if(u.getRace() == BWAPI::Races::Protoss) {
		if(u == Protoss_Citadel_of_Adun) score += Protoss_Citadel_of_Adun.mineralPrice() + Protoss_Citadel_of_Adun.gasPrice();
		if(u == Protoss_Cybernetics_Core) score += Protoss_Cybernetics_Core.mineralPrice() + Protoss_Cybernetics_Core.gasPrice();;
		if(u == Protoss_Forge) score += Protoss_Forge.mineralPrice() + Protoss_Forge.gasPrice();;
		if(u == Protoss_Robotics_Facility) score += Protoss_Robotics_Facility.mineralPrice() + Protoss_Robotics_Facility.gasPrice();;
		if(u == Protoss_Robotics_Support_Bay) score += Protoss_Robotics_Support_Bay.mineralPrice() + Protoss_Robotics_Support_Bay.gasPrice();;
		if(u == Protoss_Gateway) score += Protoss_Gateway.mineralPrice() + Protoss_Gateway.gasPrice();;
		return score;
	}



	return score;

}

int StrategyEstimator::getAirScore(UnitType u) {
	int score = 0;
	if(u.getRace() == BWAPI::Races::Terran) {
		if(u == Terran_Armory) score += Terran_Armory.mineralPrice() + Terran_Armory.gasPrice(); // dual-purpose
		if(u == Terran_Starport) score += Terran_Starport.mineralPrice() + Terran_Starport.gasPrice(); 
		if(u == Terran_Control_Tower) score += Terran_Control_Tower.mineralPrice() + Terran_Control_Tower.gasPrice(); 
		if(u == Terran_Physics_Lab) score += Terran_Physics_Lab.mineralPrice() + Terran_Physics_Lab.gasPrice();  
		return score;
	}


	if(u.getRace() == BWAPI::Races::Zerg) {
		if(u == Zerg_Spire) score += Zerg_Spire.mineralPrice() + Zerg_Spire.gasPrice();
		if(u == Zerg_Greater_Spire) score += Zerg_Spire.mineralPrice() + Zerg_Spire.gasPrice() + Zerg_Greater_Spire.mineralPrice() + Zerg_Greater_Spire.gasPrice(); 
		if(u == Zerg_Queens_Nest) score += Zerg_Queens_Nest.mineralPrice() + Zerg_Queens_Nest.gasPrice();
		return score;
	}


	if(u.getRace() == BWAPI::Races::Protoss) {
		if(u == Protoss_Arbiter_Tribunal) score += Protoss_Arbiter_Tribunal.mineralPrice() + Protoss_Arbiter_Tribunal.gasPrice(); // are these even going to be used?
		if(u == Protoss_Fleet_Beacon) score +=  Protoss_Fleet_Beacon.mineralPrice() + Protoss_Fleet_Beacon.gasPrice(); 
		if(u == Protoss_Stargate) score +=  Protoss_Stargate.mineralPrice() + Protoss_Stargate.gasPrice(); 
		return score;
	}



	return score;
}

int StrategyEstimator::estimateForceScore(std::vector<UnitModel*> knownUnits) {
	int total = 0;

	for(unsigned int i = 0; i < knownUnits.size(); i++) {
		UnitModel* m = knownUnits.at(i);	
		if(m->unitIsKnown() && !m->getUnitType().isWorker()) {
			if(m->getUnit()->isCompleted() && m->getUnitType().canAttack()) {
				if(m->isAlive()) {
					if(m->getUnitType() != UnitTypes::Zerg_Egg && m->getUnitType() != UnitTypes::Zerg_Larva && m->getUnitType() != Zerg_Overlord && m->getUnitType() != Protoss_Probe) {
						total += (m->getUnitType().mineralPrice() + m->getUnitType().gasPrice())/m->getUnitType().supplyRequired();
					}
				}
			}
		}
	}
	return total;
}



/*
int StrategyEstimator::getGroundScore(UnitType u){
	int score = 0;
	if(u.getRace() == BWAPI::Races::Terran) {
		if(u == Terran_Barracks) score += 25;
		if(u == Terran_Factory) score += 25;
		if(u == Terran_Machine_Shop) score += 25;
		if(u == Terran_Armory) score += 10; // dual-purpose
		if(u == Terran_Academy) score += 25;
		if(u == Terran_Engineering_Bay) score += 25;
		if(u == Terran_Covert_Ops) score += 25; // doesn't really count
		if(u == Terran_Science_Facility) score += 25; // iffy, usually accompanies ground units, as opposed to being used as air support?




		return score;
	}


	if(u.getRace() == BWAPI::Races::Zerg) {
		if(u == Zerg_Defiler_Mound) score += 25;
		if(u == Zerg_Evolution_Chamber) score += 25;
		if(u == Zerg_Hydralisk_Den) score += 25;
		if(u == Zerg_Nydus_Canal) score += 15;
		if(u == Zerg_Spawning_Pool) score += 25;
		if(u == Zerg_Ultralisk_Cavern) score += 25;
		return score;
	}


	if(u.getRace() == BWAPI::Races::Protoss) {
		if(u == Protoss_Citadel_of_Adun) score += 25;
		if(u == Protoss_Cybernetics_Core) score += 10;
		if(u == Protoss_Forge) score += 25;
		if(u == Protoss_Robotics_Facility) score += 10;
		if(u == Protoss_Robotics_Support_Bay) score += 25;
		if(u == Protoss_Gateway) score += 25;
		return score;
	}



	return score;

}
int StrategyEstimator::getAirScore(UnitType u) {
	int score = 0;
	if(u.getRace() == BWAPI::Races::Terran) {
		if(u == Terran_Armory) score += 10; // dual-purpose
		if(u == Terran_Starport) score += 25; 
		if(u == Terran_Control_Tower) score += 25; 
		if(u == Terran_Physics_Lab) score += 25;  
		return score;
	}


	if(u.getRace() == BWAPI::Races::Zerg) {
		if(u == Zerg_Spire) score += 25;
		if(u == Zerg_Greater_Spire) score += 50; 
		if(u == Zerg_Queens_Nest) score += 25;
		return score;
	}


	if(u.getRace() == BWAPI::Races::Protoss) {
		if(u == Protoss_Arbiter_Tribunal) score += 25; // are these even going to be used?
		if(u == Protoss_Fleet_Beacon) score += 25; 
		if(u == Protoss_Stargate) score += 50; 
		return score;
	}



	return score;
}
*/

/*
int StrategyEstimator::getAirScore(UnitType u) {
int score = 0;
if(u.getRace() == BWAPI::Races::Terran) {
if(u == Terran_Armory) score += 10; // dual-purpose
if(u == Terran_Starport) score += 25; 
if(u == Terran_Control_Tower) score += 25; 
if(u == Terran_Physics_Lab) score += 25;  
return score;
}


if(u.getRace() == BWAPI::Races::Zerg) {
if(u == Zerg_Spire) score += 25;
if(u == Zerg_Greater_Spire) score += 50; 
if(u == Zerg_Queens_Nest) score += 25;
return score;
}


if(u.getRace() == BWAPI::Races::Protoss) {
if(u == Protoss_Arbiter_Tribunal) score += 25; // are these even going to be used?
if(u == Protoss_Fleet_Beacon) score += 25; 
if(u == Protoss_Stargate) score += 50; 
return score;
}



return score;
}*/