#ifndef SQUADTACTICSMODEL_H
#define SQUADTACTICSMODEL_H
#include <BWAPI.h>
#include "SquadTactics.h"
#include "Squad.h"
#include <stack>
#include <set>
#include <map>
#include <vector>
#include <algorithm>
#include "MarineMicroTactics.h"
#include "MedicMicroTactics.h"
#include "BWTA.h"
#include "UnitModel.h" 
#include "UnitOrder.h"
using namespace BWAPI;
using namespace BWTA;

class InformationManagerAgent;
class AgentPool;
class TacticsImplementation;

class SquadTacticsModel {
public:
	SquadTacticsModel(Squad* m, int INITIAL_TACTIC, AgentPool* p, UnitOrder u);
	SquadTacticsModel(Squad* m, int INITIAL_TACTIC, AgentPool* p);
	void SquadTacticsModel::switchTactic(int NEW_TACTIC);
	Squad* SquadTacticsModel::getSquad();

	bool SquadTacticsModel::executeTactics();
	void SquadTacticsModel::initialize();
	bool SquadTacticsModel::isDead();
	int SquadTacticsModel::numAlive();
	void SquadTacticsModel::setDead();
	void SquadTacticsModel::orderReinforcements();
	int SquadTacticsModel::getTactic();
	void SquadTacticsModel::removeMember(Unit* m);

	// tactics
	bool SquadTacticsModel::executeSquadManagement();

	
private:
	Squad* element;
	std::vector<TacticsImplementation*> squadTactics;
	Squad* returnLocation;
	int CUR_TACTIC;
	AgentPool* agentPool;
	bool dead;
	UnitOrder squadMakeUp;

	// tactics

};
#endif