#include "SquadTacticsModel.h"
#include "InformationManagerAgent.h"
#include "AgentPool.h"
#include "TacticsImplementations.h"
#include "CrawlingBallAttack.h"
#include "BaseBuildingSCVTactics.h"
#include "WraithHunterKillerTactics.h"
#include "WraithAerialSquadron.h"
#include "TeleporterUsers.h"
#include "MarineSupportSquadron.h"
#include "ValkyrieAerialSquadron.h"
#include "DropShipAerialSquadron.h"
#include "SquadManagerAgent.h"
#include "VultureSupportSquadron.h"

SquadTacticsModel::SquadTacticsModel(Squad* m, int INITIAL_TACTIC, AgentPool* p, UnitOrder u) {
	element = m;
	CUR_TACTIC = INITIAL_TACTIC;
	agentPool = p;
	dead = false;
	// remember to do this via initial_tactic or something in the future
	switch(INITIAL_TACTIC) {
	case 0:	squadTactics.push_back(new CrawlingBallAttack(m, p, this));
		break;
	case 1:	squadTactics.push_back(new WraithAerialSquadron(m, p));
		break;
	case 2:	squadTactics.push_back(new ValkyrieAerialSquadron(m, p));
		break;
	case 3:	squadTactics.push_back(new DropShipAerialSquadron(m, p));
		break;
	case 4:	squadTactics.push_back(new VultureSupportSquadron(m, p));
		break;
	case 5:	squadTactics.push_back(new TeleporterUsers(m, p));
		break;
	case 6:	squadTactics.push_back(new MarineSupportSquadron(m, p));
		break;
	}
	squadMakeUp = u;
}

int SquadTacticsModel::getTactic() {
	return CUR_TACTIC;
}

	void SquadTacticsModel::removeMember(Unit* m) {

		for(unsigned int i = 0; i < element->getUnits().size(); i++) {
			if(element->getUnitAt(i) == m) {
				element->removeUnitAt(i);
			}
		}
	}

SquadTacticsModel::SquadTacticsModel(Squad* m, int INITIAL_TACTIC, AgentPool* p) {
	element = m;
	CUR_TACTIC = INITIAL_TACTIC;
	agentPool = p;
	dead = false;
	// remember to do this via initial_tactic or something in the future
	switch(INITIAL_TACTIC) {
	case 0:	squadTactics.push_back(new CrawlingBallAttack(m, p, this));
		break;
	case 1:	squadTactics.push_back(new WraithAerialSquadron(m, p));
		break;
	case 2:	squadTactics.push_back(new ValkyrieAerialSquadron(m, p));
		break;
	case 3:	squadTactics.push_back(new DropShipAerialSquadron(m, p));
		break;
	case 4:	squadTactics.push_back(new VultureSupportSquadron(m, p));
		break;
	case 5:	squadTactics.push_back(new TeleporterUsers(m, p));
		break;
	case 6:	squadTactics.push_back(new MarineSupportSquadron(m, p));
		break;
	}
}

void SquadTacticsModel::switchTactic(int NEW_TACTIC) {

}

void SquadTacticsModel::orderReinforcements() {
		//////////agentPool->writeDebugMessage("-- ordering reinforcements");
		CrawlingBallAttack* tacs = (CrawlingBallAttack*)squadTactics.at(0);
		std::vector<MicroTacticsModel*> deadGuys = tacs->getDeadUnits(UnitTypes::Terran_Marine);
		//////////agentPool->writeDebugMessage("-- reporting: ");
				//////////agentPool->writeDebugMessage((int)deadGuys.size());
					//////////agentPool->writeDebugMessage("-- dead units ");
	if(deadGuys.size() > 0){
		//////////agentPool->writeDebugMessage("-- looking for some recruits...");
		SquadManagerAgent* sm = (SquadManagerAgent*)agentPool->getAgent("SQ");
		//////////agentPool->writeDebugMessage("-- got...");
		int numRequired = deadGuys.size();
		//////////agentPool->writeDebugMessage(numRequired);
		if(numRequired > 8) {
			numRequired = 8;
		}
		//////////agentPool->writeDebugMessage("-- off we go");
		std::vector<Unit*> recruits = sm->recruitReinforcements(UnitTypes::Terran_Marine, numRequired);
				//////////agentPool->writeDebugMessage("-- got some dudes");
				if(!recruits.empty()) {
		if(recruits.size() >= deadGuys.size()) { // later on, we might just want to do the best we can do? partial fulfillment of requests
			//////////agentPool->writeDebugMessage("-- requesting the job");
			DropShipAerialSquadron* d = (DropShipAerialSquadron*)agentPool->getSquads()->getSquadByName("dropshipsquadron")->getTacticsImplementation();
			bool jobAccepted = d->requestJob(tacs, recruits);
			//////////agentPool->writeDebugMessage("-- job accepted?");
			//////////agentPool->writeDebugMessage(jobAccepted);
		}
				}

	}

}

Squad* SquadTacticsModel::getSquad() {
	return element;
}

bool SquadTacticsModel::executeTactics() {
	return executeSquadManagement();
}

void SquadTacticsModel::initialize() {

}

bool SquadTacticsModel::isDead() {
	return dead;
}

int SquadTacticsModel::numAlive() {
	int num = 0;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		if(element->getUnitAt(i)->getHitPoints() > 0) {
			num++;
		}
	}
	return num;
}


void SquadTacticsModel::setDead() {
	dead = true;
}

bool SquadTacticsModel::executeSquadManagement() {
		return squadTactics.at(0)->execute();
}