#include "SquadReccomender.h"

SquadReccomender::SquadReccomender(AgentPool* a)
{
	stage = 0;
	agentPool = a;

	marines.first = UnitTypes::Terran_Marine;
	medics.first = UnitTypes::Terran_Medic;
	firebats.first = UnitTypes::Terran_Firebat;
	scvs.first = UnitTypes::Terran_SCV;
	tanks.first = UnitTypes::Terran_Siege_Tank_Tank_Mode;
	sciencevessels.first = UnitTypes::Terran_Science_Vessel;
	goliaths.first = UnitTypes::Terran_Goliath;
	vultures.first = UnitTypes::Terran_Vulture;
	battlecruisers.first = UnitTypes::Terran_Battlecruiser;
}


UnitOrder SquadReccomender::reccomendGroundSquad()
{
	if(Broodwar->enemy()->getRace() == BWAPI::Races::Zerg) {
		getSuggestedZergSquad();
		return UnitOrder(compileManifest());
	}
	if(Broodwar->enemy()->getRace() == BWAPI::Races::Terran) {
		getSuggestedTerranSquad();
		return UnitOrder(compileManifest());
	}
	if(Broodwar->enemy()->getRace() == BWAPI::Races::Protoss) {
		getSuggestedProtossSquad();
		return UnitOrder(compileManifest());
	}

	// what if the opponent is random?
	 getSuggestedTerranSquad(); // might not even be needed.
	 return UnitOrder(compileManifest()); // better safe than sorry!
}

UnitOrder SquadReccomender::reccomendAirSquad()
{
	return UnitOrder();
}

void SquadReccomender::getSuggestedZergSquad()
{
	switch(stage) {
	case 0:
		{
			vultures.second = 1;
			marines.second = 0;
			firebats.second = 0;
			medics.second = 0;
			scvs.second = 0;
			tanks.second = 0;
			sciencevessels.second = 0;
		}
		break;
	case 1:
		{
			marines.second = 4;
			medics.second = 4; // 4
			firebats.second = 4; // 4
			tanks.second = 2;
			sciencevessels.second = 0;
			scvs.second = 1;
			goliaths.second = 0;
			vultures.second = 0;
			battlecruisers.second = 0;
		}
		break;
	case 2:
		{
			marines.second = 15; // 17
			medics.second = 7; // 7
			tanks.second = 5; // 4
			sciencevessels.second = 1; //1
			scvs.second = 2; //1 
			firebats.second = 5; // 0
			goliaths.second = 3; // 3
			vultures.second = 3;
			battlecruisers.second = 0;
		}
		break;

	case 3:
		{
			marines.second = 12;
			medics.second = 6;
			goliaths.second = 3;
			tanks.second = 4;
			sciencevessels.second = 1;
			scvs.second = 3;
			firebats.second = 0;
			vultures.second = 4;
			battlecruisers.second = 0;
		}
		break;
	case 4:
		{
			marines.second = 15;
			medics.second = 6;
			goliaths.second = 5;
			tanks.second = 4;
			sciencevessels.second = 1;
			scvs.second = 3;
			firebats.second = 0;
			vultures.second = 0;
			battlecruisers.second = 0;
		}
		break;
	}
}

void SquadReccomender::getSuggestedTerranSquad()
{
	switch(stage) {
	case 0:
		{
			vultures.second = 1;
			marines.second = 5;
			firebats.second = 0;
			medics.second = 2;
			scvs.second = 0;
			tanks.second = 0;
			sciencevessels.second = 0;
		}
		break;
	case 1: // 0
		{
			vultures.second = 4;
			marines.second = 4;
			firebats.second = 0;
			medics.second = 2;
			scvs.second = 1;
			tanks.second = 2;
			sciencevessels.second = 0;
		}
		break;
	case 2:
		{
			goliaths.second = 4;
			vultures.second = 4;
			tanks.second = 4;
			scvs.second = 2;
			sciencevessels.second = 1;
			marines.second = 8;
			medics.second = 5;
		}
		break;
	case 3:
		{
			goliaths.second = 5;
			vultures.second = 2;
			tanks.second = 4;
			scvs.second = 3;
			sciencevessels.second = 1;
			marines.second = 12;
			medics.second = 6;
		}
	case 4:
		{
			goliaths.second = 6;
			vultures.second = 4;
			tanks.second = 4;
			scvs.second = 3;
			sciencevessels.second = 1;
			marines.second = 12;
			medics.second = 6;
		}
		break;
	}
}

void SquadReccomender::getSuggestedProtossSquad()
{
	switch(stage) {
	case 0:
		{
			vultures.second = 1;
			marines.second = 0;
			firebats.second = 0;
			medics.second = 0;
			scvs.second = 0;
			tanks.second = 0;
			sciencevessels.second = 0;
		}
		break;
	case 1: // 0
		{
			vultures.second = 4;
			marines.second = 4;
			firebats.second = 0;
			medics.second = 2;
			scvs.second = 1;
			tanks.second = 2;
			sciencevessels.second = 0;
		}
		break;
	case 2:
		{
			goliaths.second = 6;
			vultures.second = 3;
			tanks.second = 4;
			scvs.second = 2;
			sciencevessels.second = 1;
			marines.second = 12;
			medics.second = 5;
		}
		break;
	case 3:
		{
			goliaths.second = 6;
			vultures.second = 3;
			tanks.second = 3;
			scvs.second = 3;
			sciencevessels.second = 1;
			marines.second = 12;
			medics.second = 5;
		}
	case 4:
		{
			goliaths.second = 6;
			vultures.second = 4;
			tanks.second = 4;
			scvs.second = 3;
			sciencevessels.second = 1;
			marines.second = 12;
			medics.second = 5;
		}
		break;
	}
}

std::vector<std::pair<UnitType, int>> SquadReccomender::compileManifest()
{
	std::vector<std::pair<UnitType, int>> manifest;
	manifest.push_back(marines);
	manifest.push_back(medics);
	manifest.push_back(tanks);
	manifest.push_back(scvs);
	manifest.push_back(sciencevessels);
	manifest.push_back(firebats);
	manifest.push_back(goliaths);
	manifest.push_back(vultures);
	manifest.push_back(battlecruisers);
	return manifest;
}

void SquadReccomender::advanceStage()
{
	if(stage < 4) {
		stage++;	
	}
}

UnitOrder SquadReccomender::getNextReccomendedSquad()
{
	if(stage + 1 <= 4) {
		stage++;
		UnitOrder u = reccomendGroundSquad();
		stage--;
		return u;
	} else {
		UnitOrder u = reccomendGroundSquad();
		return u;
	}


}
