#ifndef SquadManagerAgent_H
#define SquadManagerAgent_H
#include "GoalDescriptor.h"
#include "AgentPool.h"
#include "GoalTypes.h"
#include "SquadTacticsModel.h"
#include "UnitOrder.h"
#include "TacticsImplementations.h"
#include "CrawlingBallAttack.h"
#include <vector>


class SquadManagerAgent : public AgentBase {
public:
	
	SquadManagerAgent(AgentPool* p, SquadPool* sp);
	SquadTacticsModel* SquadManagerAgent::recruitSquad(UnitOrder u);
	SquadTacticsModel* SquadManagerAgent::recruitSquad(Squad* s, int tactic);
	std::vector<Unit*> SquadManagerAgent::recruitReinforcements(UnitType u, int num);
	bool SquadManagerAgent::isUnitInSquads(int s);
	void SquadManagerAgent::freeUnit(Unit* u);
	void SquadManagerAgent::relinquish(SquadTacticsModel* s);
	void SquadManagerAgent::activateSquad(SquadTacticsModel* s);
	void SquadManagerAgent::alertNewUnit(Unit* s);
	bool SquadManagerAgent::isUnitInSquads(Unit* s);
	SquadTacticsModel* SquadManagerAgent::getActiveSquad(int tactic);
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return NULL; };
	virtual Arbitrator* getInternalArbitrator() { return NULL; };
	void SquadManagerAgent::alertAirSquadrons(Unit* target);



private:
	AgentPool* agentPool;
	std::vector<SquadTacticsModel*> activeSquads;
	SquadPool* allSquads;
	Squad* returnPosition;
	int squadID;

	

};


#endif
