#include "SquadManagerAgent.h"
#include "ConstructionAgent.h"
#include <stdio.h>
#include <stdlib.h>

SquadManagerAgent::SquadManagerAgent(AgentPool* p, SquadPool* s) {
	agentPool = p;
	allSquads = s;
	squadID = 0;
}

bool SquadManagerAgent::isUnitInSquads(Unit* s) {

	for (std::vector<SquadTacticsModel*>::const_iterator iit = activeSquads.begin(); iit != activeSquads.end(); ++iit) {


		std::vector<Unit*> currentSquad = (*iit)->getSquad()->getUnits();
		if(!currentSquad.empty() && (*iit)->getTactic() != 4 && (*iit)->getTactic() != 5 && (*iit)->getTactic() != 6) {

			for (std::vector<Unit*>::const_iterator itt = currentSquad.begin(); itt != currentSquad.end(); ++itt) {
				if(s == (*itt)) {
			
					return true;
				}
			}	
		}

	}
	return false;
}


bool SquadManagerAgent::isUnitInSquads(int s) {

	for (std::vector<SquadTacticsModel*>::const_iterator iit = activeSquads.begin(); iit != activeSquads.end(); ++iit) {


		std::vector<Unit*> currentSquad = (*iit)->getSquad()->getUnits();
		if(!currentSquad.empty() && (*iit)->getTactic() != 4 && (*iit)->getTactic() != 5 && (*iit)->getTactic() != 6)  {

			for (std::vector<Unit*>::const_iterator itt = currentSquad.begin(); itt != currentSquad.end(); ++itt) {
				if(s == (*itt)->getID()) {
		
					return true;
				}
			}	
		}
	}
	return false;
}

SquadTacticsModel* SquadManagerAgent::recruitSquad(Squad* s, int tactic) {
	SquadTacticsModel* sm = new SquadTacticsModel(s, tactic, agentPool);
	activeSquads.push_back(sm);
	return sm;
}

void SquadManagerAgent::alertAirSquadrons(Unit* target){

}

// remember to generalize this later on!
std::vector<Unit*> SquadManagerAgent::recruitReinforcements(UnitType u, int num) {
	////////////////agentPool->writeDebugMessage("-- attempting to reinforce");
	std::vector<Unit*> availableUnits;
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::pair<UnitType, UnitType> order;

	std::vector<Unit*> targetUnits = im->getUnitsOfType(u);
	int numFound = 0;

	for (std::vector<Unit*>::const_iterator it = targetUnits.begin(); it != targetUnits.end(); ++it) {
		if(!isUnitInSquads((*it)) && numFound < 8 && !(*it)->isLoaded() && !(*it)->isMoving()) {
	
			availableUnits.push_back(*it);
			numFound++;
			if(numFound >= 8) {
				break;
			}
		}
	}

	if(availableUnits.size() >= num) {
	
		return availableUnits;
	} else {
	
		std::vector<Unit*> empty;
		return empty;
	}




}


SquadTacticsModel* SquadManagerAgent::recruitSquad(UnitOrder u) {
	std::vector<Unit*> availableUnits;
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<std::pair<UnitType, int>> order = u.getOrder();
	for(unsigned int i = 0; i < order.size(); i++) {

		std::vector<Unit*> targetUnits = im->getUnitsOfType(order.at(i).first);
		int numFound = 0;
		// for every marine
		for (std::vector<Unit*>::const_iterator it = targetUnits.begin(); it != targetUnits.end(); ++it) {

			// is this guy in one of our squads?
			bool found = false;

			// for every squad
			for (std::vector<SquadTacticsModel*>::const_iterator iit = activeSquads.begin(); iit != activeSquads.end(); ++iit) {
				std::vector<Unit*> currentSquad = (*iit)->getSquad()->getUnits();
				if(!(*iit)->getTactic() == 4 && !(*iit)->getTactic() == 5 && !(*iit)->getTactic() == 6) { // ignore the vulture micro tactics and teleporter user squads
					if(!currentSquad.empty()) {
				
						for (std::vector<Unit*>::const_iterator itt = currentSquad.begin(); itt != currentSquad.end(); ++itt) {
							// if this marine is in this squad, break
							if((*it)->getID() == (*itt)->getID() && order.at(i).first != UnitTypes::Terran_SCV) {
								found = true;
							
								continue;
							}
							if(order.at(i).first != UnitTypes::Terran_SCV && ((*it)->isCarryingGas() || (*it)->isCarryingMinerals() || (*it)->isGatheringMinerals() || (*it)->isGatheringGas() || (*it)->isConstructing() || (*it)->isRepairing())) {
								found = true;
								continue;
							}
						}	
					}
				}

				if(found){
					break;
				}
			}
	
			// phew! so if we CAN'T find this guy, we know he's available
			if(!found && numFound < (order.at(i).second*1.5)) {
				availableUnits.push_back(*it);
				numFound++;
			}
		}

		std::string name = order.at(i).first.getName().c_str();
		InformationManagerAgent* a = (InformationManagerAgent*)agentPool->getAgent("PI");


		if(numFound >= order.at(i).second) {

		} else {
			return NULL;
		}
	}
	////////////agentPool->writeDebugMessage("instantiating squad:");
	char numstr[21]; // enough to hold all numbers up to 64-bits
	sprintf_s(numstr, "groundforce %d", squadID);
	std::string cid = numstr;
	squadID++;

	for(int i = 0; i < availableUnits.size(); i++) {
		if(availableUnits.at(i)->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode || availableUnits.at(i)->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || availableUnits.at(i)->getType() == UnitTypes::Terran_Vulture || availableUnits.at(i)->getType() == UnitTypes::Terran_Marine || availableUnits.at(i)->getType() == UnitTypes::Terran_Firebat) {
			freeUnit(availableUnits.at(i));
		}
	}

	SquadTacticsModel* newSquad = new SquadTacticsModel(new Squad(cid.c_str(), availableUnits, 8), 0, agentPool, u);

	return newSquad;

}

void SquadManagerAgent::activateSquad(SquadTacticsModel* s) {
	activeSquads.push_back(s);
}

void SquadManagerAgent::freeUnit(Unit* u) {
	for(unsigned int i = 0; i < activeSquads.size(); i++){
		if(activeSquads.at(i)->getTactic() == 4 || activeSquads.at(i)->getTactic() == 6) {
		activeSquads.at(i)->removeMember(u);
		}
	}
}

void SquadManagerAgent::updateDrives() {
	for (std::vector<SquadTacticsModel*>::const_iterator it = activeSquads.begin(); it != activeSquads.end(); ++it) {
		if((*it)->getTactic() != 9000 && !(*it)->isDead()) { // ignore the temp squad
			if((*it)->executeTactics() == false) {
				relinquish(*it);
				continue;
			}
		}
	}
}

void SquadManagerAgent::relinquish(SquadTacticsModel* m) {
	
	m->setDead();
}

void SquadManagerAgent::alertNewUnit(Unit* s) {
	if(s->getType() == UnitTypes::Terran_Wraith) {
		allSquads->getSquadByName("wraithsquadron")->addUnit(s);
	}
	if(s->getType() == UnitTypes::Terran_Valkyrie) {
		allSquads->getSquadByName("valkyriesquadron")->addUnit(s);
	}
	if(s->getType() == UnitTypes::Terran_Dropship) {
		allSquads->getSquadByName("dropshipsquadron")->addUnit(s);
	}
	if(s->getType() == UnitTypes::Terran_Vulture) {
		allSquads->getSquadByName("vulturesquadron")->addUnit(s);
	}
	if(s->getType() == UnitTypes::Terran_Marine || s->getType() == UnitTypes::Terran_Firebat) {
		allSquads->getSquadByName("marinesupport")->addUnit(s);
	}
	if(s->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		allSquads->getSquadByName("marinesupport")->addUnit(s);
	}
	if(!s->getType().isFlyer()) {
		allSquads->getSquadByName("teleporterusers")->addUnit(s);
	}
}

SquadTacticsModel* SquadManagerAgent::getActiveSquad(int tactic) {
	for(unsigned int i = 0; i < activeSquads.size(); i++){
		if(activeSquads.at(i)->getTactic() == tactic) {
			return activeSquads.at(i);
		}
	}
	return NULL;
}