#ifndef SQUAD_H
#define SQUAD_H
#include <iostream>
#include <vector>
#include <BWAPI.h>

class TacticsImplementation;

using namespace BWAPI;
class Squad {
public:
	Squad::Squad(std::string name, int s);
	Squad::Squad(std::string name, std::vector<Unit*> units, int s);
	void Squad::addUnit(Unit* u);
		void Squad::forceUnit(Unit* u);
	std::vector<Unit*> Squad::getUnits();
	std::string name();
	Unit* Squad::getUnitAt(int x);
	void Squad::removeUnitAt(unsigned int u);
	void Squad::removeUnit(Unit* u);
	bool Squad::containsUnit(Unit* u);
	std::vector<Unit*> Squad::getLivingUnits();
	void Squad::alertTacticsImplementation(Unit* u);
	TacticsImplementation* Squad::getTacticsImplementation();
	void Squad::attachTacticsImplementation(TacticsImplementation* t);

	Position Squad::getMostCentralElement(Unit* u);
	Position Squad::getMostCentralElement();
	bool Squad::canMaintainCentralPosition(Unit* u);
	bool Squad::allMembersInPosition();

private:
	std::string squadName;
	std::vector<Unit*> members;
	TacticsImplementation* tactics;
	int squadCohesion;

};
#endif