#include "Squad.h"
#include "TacticsImplementations.h"

Squad::Squad(std::string sN, int s) {
	squadName = sN;
	tactics = NULL;
	squadCohesion = s;
}

Squad::Squad(std::string sN, std::vector<Unit*> units, int s) {
	squadCohesion = s;
	squadName = sN;
	for (std::vector<Unit*>::const_iterator it = units.begin(); it != units.end(); ++it)
	{
		members.push_back(*it);
	}


}

TacticsImplementation* Squad::getTacticsImplementation() {
	return tactics;
}

	void Squad::alertTacticsImplementation(Unit* u) {
		////Broodwar->sendText("tactics implementation alerted....");
		tactics->receiveAlert(u);
	}

	void Squad::attachTacticsImplementation(TacticsImplementation* t) {
		tactics = t;
	}

	bool Squad::allMembersInPosition() {

		for(unsigned int i = 0; i < members.size(); i++) {
			Unit* member = members.at(i);
			if(!canMaintainCentralPosition(member)) {
				return false;
			}
		}
		return true;
	}

	bool Squad::canMaintainCentralPosition(Unit* u) {
		Position centralElement = getMostCentralElement(u);
		int activeMembers = 0;
		for(unsigned int i = 0; i < members.size(); i++) {
			Unit* member = members.at(i);
			if(member->getHitPoints() > 0 && member->isCompleted() && member != u) {
				activeMembers++;
			}
		}
		// hooray! magic numbers!!


			if(u->getPosition().getDistance(centralElement) <= 7.48*activeMembers) { // was 6.48
				return true;
			}
	

		return false;
	}

	// relative to a particular unit
Position Squad::getMostCentralElement(Unit* u) {
	if(members.size() == 1) {
		return members.at(0)->getPosition();
	}
	// first find the average central position of the entire squad
	// then find the guy that is the closest to it.
	int avgX = 0;
	int avgY = 0;
	int activeMembers = 0;
	for(unsigned int i = 0; i < members.size(); i++) {
		Unit* member = members.at(i);
		if(member->getHitPoints() > 0 && member->isCompleted() && member != u) {
			avgX += member->getPosition().x();
			avgY += member->getPosition().y();
			activeMembers++;
		}
	}
	if(activeMembers != 0) {
		avgX /= activeMembers;
		avgY /= activeMembers;
	}

	Position centre = Position(avgX, avgY);
	
	Unit* mostCentralAgentSoFar = members.at(0);
	for(unsigned int i = 0; i < members.size(); i++) {
		Unit* member = members.at(i);
		if(member->getDistance(centre) < mostCentralAgentSoFar->getDistance(centre)) {
			mostCentralAgentSoFar = member;
		}
	}
	
	Position p = mostCentralAgentSoFar->getPosition();
	return p;

}


	// overall central position
Position Squad::getMostCentralElement() {
	// first find the average central position of the entire squad
	// then find the guy that is the closest to it.
	if(members.size() == 1) {
		return members.at(0)->getPosition();
	}
	int avgX = 0;
	int avgY = 0;
	int activeMembers = 0;
	for(unsigned int i = 0; i < members.size(); i++) {
		Unit* member = members.at(i);
		if(member->getHitPoints() > 0 && member->isCompleted()) {
			avgX += member->getPosition().x();
			avgY += member->getPosition().y();
			activeMembers++;
		}
	}
	if(activeMembers != 0) {
		avgX /= activeMembers;
		avgY /= activeMembers;
	}

	Position centre = Position(avgX, avgY);

	Unit* mostCentralAgentSoFar = members.at(0);
	for(unsigned int i = 0; i < members.size(); i++) {
		Unit* member = members.at(i);
		if(member->getDistance(centre) < mostCentralAgentSoFar->getDistance(centre)) {
			mostCentralAgentSoFar = member;
		}
	}

	return mostCentralAgentSoFar->getPosition();

}

Unit* Squad::getUnitAt(int x) {
	return members.at(x);
}

std::vector<Unit*> Squad::getUnits() {
	return members;
}

std::vector<Unit*> Squad::getLivingUnits() {
	std::vector<Unit*> output;
	for(unsigned int i = 0; i < members.size(); i++) {

		if(members.at(i)->isCompleted() && members.at((i))->getHitPoints() >0) {
			output.push_back(members.at((i)));
		}
	}
	return output;
}

void Squad::removeUnit(Unit* u) {
	for(unsigned int i = 0; i < members.size(); i++) {
	
		if((members.at(i)) == u) {
			//	////agentPool->writeDebugMessage("mrneer");
			members.erase(members.begin()+i);
			//break;
		}
	}
}

bool Squad::containsUnit(Unit* u) {
		for (std::vector<Unit*>::const_iterator it = members.begin(); it != members.end(); ++it)
		{
			if((*it) == u) {
				return true;
			}
		}
	return false;
	}

std::string Squad::name() {
	return squadName;
}

void Squad::addUnit(Unit* u) {
	if(!containsUnit(u)) {
		members.push_back(u);
		if(tactics != NULL){ 
			alertTacticsImplementation(u);
		}
	}

}

		void Squad::forceUnit(Unit* u) {
			if(!containsUnit(u)) {
				members.push_back(u);
			}
		}

void Squad::removeUnitAt(unsigned int u) {
	if(u < members.size() ) {
		if(tactics != NULL) {
			tactics->removeUnit(members.at(u));
		}
//			////agentPool->writeDebugMessage("rem unit membezs");
		members.erase(members.begin()+u);
		
	}
}