#include "QuorumModule.h"
#include <time.h>
using namespace BWAPI;

bool analyzed;
bool analysis_just_finished;
bool alt;
bool initialized;
BWTA::Region* home;
BWTA::Region* enemy_base;
AgentPool* agentPool;

void QuorumModule::onStart()
{
	initialized = false;
	Broodwar->printf("The map is %s, a %d player map",Broodwar->mapName().c_str(),Broodwar->getStartLocations().size());
	Broodwar->enableFlag(Flag::UserInput);
		alt = true;
		//Broodwar->setLocalSpeed(0);
		//Broodwar->setFrameSkip(4092);
		
		//////////agentPool->writeDebugMessage(game, "C:\\quorumdebugger\\gamesplayed.txt");
	//	game++;
	//////////////////////////agentPool->writeDebugMessage("scanning terrain...");
	analyzed=false;
	analysis_just_finished=false;
	//read map information into BWTA so terrain analysis can be done in another thread
	BWTA::readMap();
	CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)AnalyzeThread, NULL, 0, NULL);
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if ((*i)->getType().isWorker())
		{
			Unit* closestMineral=NULL;
			for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++)
			{
				if (closestMineral==NULL || (*i)->getDistance(*m)<(*i)->getDistance(closestMineral))
					closestMineral=*m;
			}
			if (closestMineral!=NULL)
				(*i)->rightClick(closestMineral);
		}
		else if ((*i)->getType().isResourceDepot())
		{
			//if this is a center, tell it to build the appropiate type of worker
			if ((*i)->getType().getRace()!=Races::Zerg)
			{
				//////////////////////////agentPool->writeDebugMessage("training initial worker");
				(*i)->train(Broodwar->self()->getRace().getWorker());
			}
		}
	}

	setUp();



	show_bullets=false;
	show_visibility_data=false;

	if (Broodwar->isReplay())
	{
		Broodwar->printf("The following players are in this replay:");
		for(std::set<Player*>::iterator p=Broodwar->getPlayers().begin();p!=Broodwar->getPlayers().end();p++)
		{
			if (!(*p)->getUnits().empty() && !(*p)->isNeutral())
			{
				Broodwar->printf("%s, playing as a %s",(*p)->getName().c_str(),(*p)->getRace().getName().c_str());
			}
		}
	}
	else
	{
			Broodwar->printf("The match up is %s v %s",
			Broodwar->self()->getRace().getName().c_str(),
			Broodwar->enemy()->getRace().getName().c_str());

	}

	}

	void QuorumModule::onEnd(bool isWinner)
	{


	}

	void QuorumModule::onFrame()
	{
		agentPool->updateAgentDrives();
	}

	void QuorumModule::onSendText(std::string text)
	{
		if (text=="/show bullets")
		{
			show_bullets = !show_bullets;
		} else if (text=="/show players")
		{
			showPlayers();
		} else if (text=="/show forces")
		{
			showForces();
		} else if (text=="/show visibility")
		{
			show_visibility_data=!show_visibility_data;
		} else if (text=="/analyze")
		{
			if (analyzed == false)
			{
				Broodwar->printf("Analyzing map... this may take a minute");
				CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)AnalyzeThread, NULL, 0, NULL);
			}
		} else
		{
			Broodwar->printf("You typed '%s'!",text.c_str());
			//////////Broodwar->sendText("%s",text.c_str());
		}
	}

	void QuorumModule::onReceiveText(BWAPI::Player* player, std::string text)
	{
		Broodwar->printf("%s said '%s'", player->getName().c_str(), text.c_str());
	}

	void QuorumModule::onPlayerLeft(BWAPI::Player* player)
	{
		//////////Broodwar->sendText("%s left the game.",player->getName().c_str());
	}

	void QuorumModule::onNukeDetect(BWAPI::Position target)
	{
		if (target!=Positions::Unknown)
			Broodwar->printf("Nuclear Launch Detected at (%d,%d)",target.x(),target.y());
		else
			Broodwar->printf("Nuclear Launch Detected");
	}

	void QuorumModule::onUnitDiscover(BWAPI::Unit* unit)
	{ 
		if(initialized) {
			//  if (!Broodwar->isReplay() && Broodwar->getFrameCount()>1)	//////////Broodwar->sendText("A %s [%x] has been discovered at (%d,%d)",unit->getType().getName().c_str(),unit,unit->getPosition().x(),unit->getPosition().y());
			if(!unit->getType().isNeutral() && !unit->getType().isSpecialBuilding() && !unit->getType().isResourceContainer()) {
				if(unit->getPlayer()->getID() != Broodwar->self()->getID()) {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");
					im->alert(unit);
				} else {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					im->alert(unit);
				}
			}
		}
	}


	void QuorumModule::onUnitEvade(BWAPI::Unit* unit)
	{
		// if (!Broodwar->isReplay() && Broodwar->getFrameCount()>1)
		//////////Broodwar->sendText("A %s [%x] was last accessible at (%d,%d)",unit->getType().getName().c_str(),unit,unit->getPosition().x(),unit->getPosition().y());
	}

	void QuorumModule::onUnitShow(BWAPI::Unit* unit)
	{
		if(initialized) {
			// if (!Broodwar->isReplay() && Broodwar->getFrameCount()>1)
			//////////Broodwar->sendText("A %s [%x] has been spotted at (%d,%d)",unit->getType().getName().c_str(),unit,unit->getPosition().x(),unit->getPosition().y());
			if(!unit->getType().isNeutral() && !unit->getType().isSpecialBuilding() && !unit->getType().isResourceContainer()) {
				if(unit->getPlayer()->getID() != Broodwar->self()->getID()) {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");
					im->alert(unit);
				} else {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					im->alert(unit);
				}
			}
		}
	}

	void QuorumModule::onUnitHide(BWAPI::Unit* unit)
	{
		// if (!Broodwar->isReplay() && Broodwar->getFrameCount()>1)
		//////////Broodwar->sendText("A %s [%x] was last seen at (%d,%d)",unit->getType().getName().c_str(),unit,unit->getPosition().x(),unit->getPosition().y());
	}

	void QuorumModule::onUnitCreate(BWAPI::Unit* unit)
	{
		if(initialized) {

			if(!unit->getType().isNeutral() && !unit->getType().isSpecialBuilding()) {
				if(unit->getPlayer()->getID() != Broodwar->self()->getID()) {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");
					im->alert(unit);
				} else {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					im->alert(unit);
				}
			}
			if(unit->getType().isWorker() && unit->getPlayer()->getID() == Broodwar->self()->getID()) {
				if(!agentPool->getSquads()->getSquadByName("scouts")->containsUnit(unit)) {
					agentPool->getSquads()->getSquadByName("workers")->addUnit(unit);
				}
			}
		}
	}

	void QuorumModule::onUnitDestroy(BWAPI::Unit* unit)
	{
		if(initialized) {
			/*
			Remember: this should also, in the future, take care of OUR OWN destroyed units
			*/
			if(!unit->getType().isNeutral() && !unit->getType().isSpecialBuilding() && !unit->getType().isResourceContainer()) {
				if(unit->getPlayer()->getID() != Broodwar->self()->getID()) {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");
					im->destroyed(unit);
				} else {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					im->destroyed(unit);
				}
			}
		}

	}

	void QuorumModule::onUnitMorph(BWAPI::Unit* unit)
	{
		if(initialized) {
			if(!unit->getType().isNeutral() && !unit->getType().isSpecialBuilding()) {
				if(unit->getPlayer()->getID() != Broodwar->self()->getID()) {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");
					im->alert(unit);
				} else {
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					im->alert(unit);
				}
			}
		}
	}

	void QuorumModule::onUnitRenegade(BWAPI::Unit* unit)
	{
		// if (!Broodwar->isReplay())
		//////////Broodwar->sendText("A %s [%x] is now owned by %s",unit->getType().getName().c_str(),unit,unit->getPlayer()->getName().c_str());

	}

	void QuorumModule::onSaveGame(std::string gameName)
	{
		Broodwar->printf("The game was saved to \"%s\".", gameName.c_str());
	}

	DWORD WINAPI AnalyzeThread()
	{

	//	Broodwar->printf("analyzing map");
		BWTA::analyze();
	//	Broodwar->printf("analysis complete");
		analyzed = true;
		analysis_just_finished = true;

		agentPool->launched = true;
			//Broodwar->setLocalSpeed(0);
			//Broodwar->setFrameSkip(3);
		return 0;



	}

	void QuorumModule::drawStats()
	{
		std::set<Unit*> myUnits = Broodwar->self()->getUnits();
		Broodwar->drawTextScreen(5,0,"I have %d units:",myUnits.size());
		std::map<UnitType, int> unitTypeCounts;
		for(std::set<Unit*>::iterator i=myUnits.begin();i!=myUnits.end();i++)
		{
			if (unitTypeCounts.find((*i)->getType())==unitTypeCounts.end())
			{
				unitTypeCounts.insert(std::make_pair((*i)->getType(),0));
			}
			unitTypeCounts.find((*i)->getType())->second++;
		}
		int line=1;
		for(std::map<UnitType,int>::iterator i=unitTypeCounts.begin();i!=unitTypeCounts.end();i++)
		{
			Broodwar->drawTextScreen(5,16*line,"- %d %ss",(*i).second, (*i).first.getName().c_str());
			line++;
		}
	}

	void QuorumModule::drawBullets()
	{
		std::set<Bullet*> bullets = Broodwar->getBullets();
		for(std::set<Bullet*>::iterator i=bullets.begin();i!=bullets.end();i++)
		{
			Position p=(*i)->getPosition();
			double velocityX = (*i)->getVelocityX();
			double velocityY = (*i)->getVelocityY();
			if ((*i)->getPlayer()==Broodwar->self())
			{
				Broodwar->drawLineMap(p.x(),p.y(),p.x()+(int)velocityX,p.y()+(int)velocityY,Colors::Green);
				Broodwar->drawTextMap(p.x(),p.y(),"\x07%s",(*i)->getType().getName().c_str());
			}
			else
			{
				Broodwar->drawLineMap(p.x(),p.y(),p.x()+(int)velocityX,p.y()+(int)velocityY,Colors::Red);
				Broodwar->drawTextMap(p.x(),p.y(),"\x06%s",(*i)->getType().getName().c_str());
			}
		}
	}

	void QuorumModule::drawVisibilityData()
	{
		for(int x=0;x<Broodwar->mapWidth();x++)
		{
			for(int y=0;y<Broodwar->mapHeight();y++)
			{
				if (Broodwar->isExplored(x,y))
				{
					if (Broodwar->isVisible(x,y))
						Broodwar->drawDotMap(x*32+16,y*32+16,Colors::Green);
					else
						Broodwar->drawDotMap(x*32+16,y*32+16,Colors::Blue);
				}
				else
					Broodwar->drawDotMap(x*32+16,y*32+16,Colors::Red);
			}
		}
	}

	void QuorumModule::drawTerrainData()
	{
		//we will iterate through all the base locations, and draw their outlines.
		//for(std::set<BWTA::BaseLocation*>::const_iterator i=BWTA::getBaseLocations().begin();i!=BWTA::getBaseLocations().end();i++)
		//{
		//TilePosition p=(*i)->getTilePosition();
		//	Position c=(*i)->getPosition();

		//draw outline of center location
		//	Broodwar->drawBox(CoordinateType::Map,p.x()*32,p.y()*32,p.x()*32+4*32,p.y()*32+3*32,Colors::Blue,false);
		/*
		//draw a circle at each mineral patch

		for(std::set<BWAPI::Unit*>::const_iterator j=(*i)->getStaticMinerals().begin();j!=(*i)->getStaticMinerals().end();j++)
		{
		Position q=(*j)->getInitialPosition();
		Broodwar->drawCircle(CoordinateType::Map,q.x(),q.y(),30,Colors::Cyan,false);
		}

		//draw the outlines of vespene geysers
		for(std::set<BWAPI::Unit*>::const_iterator j=(*i)->getGeysers().begin();j!=(*i)->getGeysers().end();j++)
		{
		TilePosition q=(*j)->getInitialTilePosition();
		Broodwar->drawBox(CoordinateType::Map,q.x()*32,q.y()*32,q.x()*32+4*32,q.y()*32+2*32,Colors::Orange,false);
		}

		//if this is an island expansion, draw a yellow circle around the base location
		if ((*i)->isIsland())
		Broodwar->drawCircle(CoordinateType::Map,c.x(),c.y(),80,Colors::Yellow,false);
		*/
		//	}
		/*
		//we will iterate through all the regions and draw the polygon outline of it in green.
		for(std::set<BWTA::Region*>::const_iterator r=BWTA::getRegions().begin();r!=BWTA::getRegions().end();r++)
		{
		BWTA::Polygon p=(*r)->getPolygon();
		for(unsigned int j=0;j<(int)p.size();j++)
		{
		Position point1=p[j];
		Position point2=p[(j+1) % p.size()];
		Broodwar->drawLine(CoordinateType::Map,point1.x(),point1.y(),point2.x(),point2.y(),Colors::Green);
		}
		}

		//we will visualize the chokepoints with red lines
		for(std::set<BWTA::Region*>::const_iterator r=BWTA::getRegions().begin();r!=BWTA::getRegions().end();r++)
		{
		for(std::set<BWTA::Chokepoint*>::const_iterator c=(*r)->getChokepoints().begin();c!=(*r)->getChokepoints().end();c++)
		{
		Position point1=(*c)->getSides().first;
		Position point2=(*c)->getSides().second;
		Broodwar->drawLine(CoordinateType::Map,point1.x(),point1.y(),point2.x(),point2.y(),Colors::Red);
		}
		}
		*/
	}

	void QuorumModule::showPlayers()
	{
		std::set<Player*> players=Broodwar->getPlayers();
		for(std::set<Player*>::iterator i=players.begin();i!=players.end();i++)
		{
			Broodwar->printf("Player [%d]: %s is in force: %s",(*i)->getID(),(*i)->getName().c_str(), (*i)->getForce()->getName().c_str());
		}
	}

	void QuorumModule::showForces()
	{
		std::set<Force*> forces=Broodwar->getForces();
		for(std::set<Force*>::iterator i=forces.begin();i!=forces.end();i++)
		{
			std::set<Player*> players=(*i)->getPlayers();
			Broodwar->printf("Force %s has the following players:",(*i)->getName().c_str());
			for(std::set<Player*>::iterator j=players.begin();j!=players.end();j++)
			{
				Broodwar->printf("  - Player [%d]: %s",(*j)->getID(),(*j)->getName().c_str());
			}
		}
	}

	void QuorumModule::setUp(){ 
		agentPool = new AgentPool();
		initialized = true;

	}