#include "SiegeTankMicroTactics.h"
#include "CrawlingBallAttack.h"
#include <cmath>


SiegeTankMicroTactics::SiegeTankMicroTactics(Unit* u, CrawlingBallAttack* c) {
	element = u;
	//closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	lastTarget = NULL;
	squadTarget = NULL;
	myTarget = NULL;
	squadTactics = c;
	knownType = u->getType();
}

SiegeTankMicroTactics::SiegeTankMicroTactics(Unit* u, int movementLag) {
	element = u;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	lastTarget = NULL;
	squadTarget = NULL;
	myTarget = NULL;
	knownType = u->getType();
}
UnitType SiegeTankMicroTactics::getKnownType() {
	return knownType;
}


void SiegeTankMicroTactics::move(Position p) {
	if(element->isMoving()) return;
	int initPopSize = 64; // was 500
	int initPopVariance = 256; // was 32
	std::vector<Position> population;
	std::vector<Position> solution;

	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);

		population.push_back(newPosition);
	}

	// find the best member
	Position bestPosition = element->getPosition();
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		if((n.getApproxDistance(p) < bestPosition.getApproxDistance(p)) && element->hasPath(n)) {
			bestPosition = n;
			solution.push_back(n);
		}
	}


	element->move(bestPosition);

}

void SiegeTankMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
	movementLagTimer = l;
}


void SiegeTankMicroTactics::setTarget(Unit* t) {
	squadTarget = t;
}

void SiegeTankMicroTactics::clearTarget() {
	squadTarget = NULL;
}



bool SiegeTankMicroTactics::executeTactics() {
	if(element->getHitPoints() <= 0) {
		return false;
	}

	std::set<Unit*> enemies = element->getUnitsInRadius(BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange());
	int enemyCount = 0;
	Unit* bestTarget = NULL;
	int bestFitness = 0;
	Unit* nz = NULL;
	int z = 0;
	for(std::set<Unit*>::const_iterator i = enemies.begin(); i != enemies.end(); i++) {
		if((*i)->getPlayer() != Broodwar->self() && !(*i)->getPlayer()->isNeutral()) {
			if(!(*i)->getType().isFlyer() && !(*i)->getType().isWorker() && ((*i)->getType().canAttack() || (*i)->getType() == UnitTypes::Terran_Bunker || (*i)->getType() == UnitTypes::Terran_Missile_Turret || (*i)->getType() == UnitTypes::Zerg_Spore_Colony || (*i)->getType() == UnitTypes::Protoss_Photon_Cannon|| (*i)->getType() == UnitTypes::Zerg_Sunken_Colony)) {

				enemyCount++;
				if(bestTarget == NULL) {
					bestTarget = *i;
					bestFitness = fitnessCalculator->calculateMechFitness(*i);
				} else {
					int fitness = fitnessCalculator->calculateMechFitness(*i);
					if(fitness > bestFitness) {
						bestTarget = *i;
						bestFitness = fitness;
					}
				}
				int thresh = 96;
				if(element->isSieged()) {
					thresh = 150;
				}
				if(((*i)->getType() == Protoss_Zealot || (*i)->getType() == Zerg_Zergling) && (*i)->getDistance(element) <= thresh) {
					z++;
					if(nz == NULL) {
						nz = *i;
					} else{
						if(element->getDistance(*i) < element->getDistance(nz)) {
							nz = *i;
						}
					}

				}
			}
		}
	}

	if(nz != NULL && element->getHitPoints() < element->getType().maxHitPoints()) {
		int tx = nz->getPosition().x();
		int ty = nz->getPosition().y();
		int mx = element->getPosition().x();
		int my = element->getPosition().y();

		int nx = 0;
		int ny = 0;

		// if the enemy is to my right
		if(tx >= mx) {
			// move far left
			nx = (tx-350);
		} else {
			// move far right
			nx = tx+350;
		}

		// if the enemy is below me
		if(ty >= my) {
			// move up
			ny = (ty-350);
		} else {
			// move down
			ny = (ty+350);
		}
		////Broodwar->sendText("bailing!");
		if(element->isSieged()) {
			element->unsiege();
		}
		move(Position(nx,ny));
		return true;
	}


	if(enemyCount == 0) {
		if(element->isSieged()) {
			element->unsiege();
		}
	} else {
		if(!element->isSieged()) {
			element->siege();
			return true;
		} else {
			if(element->getGroundWeaponCooldown() <= 0){
				element->attack(bestTarget);
				return true;
			}
		}
	}
	return false;
}

Unit* SiegeTankMicroTactics::getUnit() {
	return element;
}

