#ifndef SCOUTTACTICSMODEL_H
#define SCOUTTACTICSMODEL_H
#include <BWAPI.h>
#include "ScoutTactics.h"
#include "Squad.h"
#include <stack>
#include <set>
#include <map>
#include <vector>
#include <algorithm>


using namespace BWAPI;

class AgentPool;

class ScoutTacticsModel {
public:
	ScoutTacticsModel::ScoutTacticsModel(Unit* m, int INITIAL_TACTIC, Squad* r, AgentPool* p);
	void ScoutTacticsModel::switchTactic(int NEW_TACTIC);
	Unit* ScoutTacticsModel::getUnit();
	bool ScoutTacticsModel::executeTactics();
	void ScoutTacticsModel::initialize();
	Squad* ScoutTacticsModel::getReturnLocation();
	void ScoutTacticsModel::scoutMove(Position p);

	// tactics
	bool ScoutTacticsModel::executeBaseTourTactic();
	
	
private:
	Unit* element;
	Unit* targetOfInterest;
	Squad* returnLocation;
	int CUR_TACTIC;
	std::vector<BWAPI::Position> startLocations;
	AgentPool* agentPool;

	// tactics
	// base tour tactic
	BWAPI::Position currentTarget;
	BWAPI::Position closestBase;
	bool stop;

};
#endif