#include "ScoutTacticsModel.h"
#include "AgentPool.h"
#include "OffensiveTacticsManagerAgent.h"

ScoutTacticsModel::ScoutTacticsModel(Unit* m, int INITIAL_TACTIC, Squad* r, AgentPool* p) {
	//////////////////////////agentPool->writeDebugMessage("scout model created...");
	element = m;
	CUR_TACTIC = INITIAL_TACTIC;
	returnLocation = r;
	agentPool = p;
	returnLocation->removeUnit(m);
	stop = false;
	//////////////////////////agentPool->writeDebugMessage("trying to initialize scout model...");
	initialize();
}

Unit* ScoutTacticsModel::getUnit() {
	return element;
}

void ScoutTacticsModel::initialize() {
	//////////////////////////agentPool->writeDebugMessage("initializing scout model...");
	startLocations.clear();
	for (std::set<BWAPI::TilePosition>::const_iterator it = BWAPI::Broodwar->getStartLocations().begin(); it != BWAPI::Broodwar->getStartLocations().end(); ++it)
	{
			//////////////////////////agentPool->writeDebugMessage("\t pushed one location to move to");
			if(*it == Broodwar->self()->getStartLocation()) {
			} else {
				startLocations.push_back((Position)(*it));
			}

	}
		//////////////////////////agentPool->writeDebugMessage("\t sorting!");


	std::sort(startLocations.begin(),startLocations.end());
	//////////////////////////agentPool->writeDebugMessage("\t we have...");
	//////////////////////////agentPool->writeDebugMessage((int)startLocations.size());
	//////////////////////////agentPool->writeDebugMessage("\t to go to");

	currentTarget = startLocations.back();
	element->move(currentTarget);
	////////Broodwar->sendText("done!");
}

bool ScoutTacticsModel::executeTactics() {
	switch(CUR_TACTIC) {
	case 0: return executeBaseTourTactic();
	}

	// this might be a bad idea
	return true;
}

Squad* ScoutTacticsModel::getReturnLocation() {
	return returnLocation;
}


	/*

		Tactics code

	*/



	/*

		Base tour scout tactics

	*/

	void ScoutTacticsModel::scoutMove(Position p) {
		if(Broodwar->getFrameCount()%6==0) {
		std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
		std::vector<Unit*> dangerFilter;
		for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
		{
			Unit* target = *it;
			if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
				if(target->getType().isWorker() || target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
					dangerFilter.push_back(target);
				}
			}
		}
		Position bestPosition = p;
		if(!dangerFilter.empty()) {
		int initPopSize = 32;
		int initPopVariance = 256;
		std::vector<Position> population;
		for(int i = 0; i < initPopSize; i++) {
			Position newPosition = element->getPosition();
			int newX = rand()%initPopVariance;
			int newY = rand()%initPopVariance;
			if(rand()%100 >= 50) newX = -newX;
			if(rand()%100 >= 50) newY = -newY;
			newPosition = Position(element->getPosition().x()+newX, element->getPosition().y()+newY);

			population.push_back(newPosition);

		}

		// find the best member
		
		int bestFitness = 90000;

		for(int i = 0; i < initPopSize; i++) {
			Position n = population.at(i);
			int threatOfMove = 0;
				//Broodwar->drawCircle(CoordinateType::Map, population.at(i).x(), population.at(i).y(), 1, Colors::Red);
			for(unsigned int k = 0; k < dangerFilter.size(); k++) {
				int distance = n.getDistance(dangerFilter.at(k)->getPosition());
				int minRange = 1;
				int maxRange = dangerFilter.at(k)->getType().sightRange();
				if(minRange < distance && maxRange >= distance) {
					threatOfMove+=250;
				}
			}

			int fitness = n.getApproxDistance(p);
			if(fitness < bestFitness && element->hasPath(n) && threatOfMove == 0) 
			{
				bestPosition = n;
				bestFitness = fitness;
			}

		}
		}
	
		
				element->move(bestPosition);

		}

	}

bool ScoutTacticsModel::executeBaseTourTactic() {
	// if i've found the main base, just quit
	if(element->isUnderAttack()) {
		////Broodwar->sendText("i'm out of here!!");
		element->move((Position)Broodwar->self()->getStartLocation());
		return false;
	}
	if(stop) {
		OffensiveTacticsManagerAgent* o = (OffensiveTacticsManagerAgent*)agentPool->getAgent("O");
		o->pushTargetOfOpportunity(OFFENSE_GASSTEAL, element, (targetOfInterest));
		if(element->getDistance(targetOfInterest) > 125 && targetOfInterest != NULL) {
			element->move(targetOfInterest->getPosition());
			return true;
		}
		if(element->getBuildUnit() != NULL) {
			if(element->getBuildUnit()->getType() != UnitTypes::Terran_Refinery) {
				return false;
			}
			//if(element->getBuildUnit()->getRemainingBuildTime() < 50) {
				//////////Broodwar->sendText("abandoning my deadly game!");
				//element->haltConstruction();
				//targetOfInterest = NULL;
				//element->move((Position)Broodwar->self()->getStartLocation());
				return false;
				/*
				std::set<BWAPI::Unit*> nbrs = element->getUnitsInRadius(element->getType().sightRange());
				if(!element->isAttacking()) {
				for (std::set<BWAPI::Unit*>::const_iterator it = nbrs.begin(); it != nbrs.end(); ++it) {
					if(((*it)->isCompleted() && ((*it)->getPlayer() == Broodwar->enemy()) && ((*it)->getType().isResourceDepot() || (*it)->getType().isWorker()))) {
					//	element->attack(*it);
						break;
					}
				}
				}
				*/
		//	}
		}

		return true;
	}

	if(!stop) {


		std::set<BWAPI::Unit*> nbrs = element->getUnitsInRadius(element->getType().sightRange());
	if(!nbrs.empty()) {
	bool baseFound = false;
	for (std::set<BWAPI::Unit*>::const_iterator it = nbrs.begin(); it != nbrs.end(); ++it) {
		if(!(*it)->getType().isNeutral() && !(*it)->getType().isSpecialBuilding() && (*it)->getPlayer() == Broodwar->enemy() && (*it)->getType().isResourceDepot()) {
			baseFound = true;
			////Broodwar->sendText("enemy base found");
			break;
		}
	}

	if(baseFound) {
	for (std::set<BWAPI::Unit*>::const_iterator it = nbrs.begin(); it != nbrs.end(); ++it) {
			if((*it)->getType() == UnitTypes::Resource_Vespene_Geyser) {
					////Broodwar->sendText("i could do a gas steal");
					scoutMove((*it)->getPosition());
					currentTarget = (*it)->getPosition();
					targetOfInterest = (*it);
					agentPool->getSquads()->getSquadByName("workers")->removeUnit(element);
					stop = true;
					break;
			}
		}
		return true;
	}

	}
	if(startLocations.empty()) {
		return false; // quit the search
	}

	// if i am at my target, pop it
	if(element->getDistance(currentTarget) < 50) {
		startLocations.pop_back();
		if(startLocations.empty()) {
			return false;
		}
		if(startLocations.back() == (Position)BWAPI::Broodwar->self()->getStartLocation()) {
			startLocations.pop_back();
		}
		if(startLocations.empty()) {
			return false;
		}
		std::sort(startLocations.begin(),startLocations.end());
		currentTarget = startLocations.back();
		scoutMove(currentTarget);
		return true;
	} else {
		scoutMove(currentTarget);
	}
	
	
	return true;
	}
	if(element->isConstructing()) {
		if(element->getBuildUnit() != NULL) {
			if(element->getBuildUnit()->getRemainingBuildTime() <= 25) {
				//////////////////////////agentPool->writeDebugMessage("all done! quitting the GAS STEAL");
				return false; // christ, talk about long-winded
			}
		}
	}
	return true;
}