#ifndef SVMICRO_H
#define SVMICRO_H
#include "MicroTacticsModel.h"
#include "UnitModel.h"
#include "InformationManagerAgent.h"

class ScienceVesselMicroTactics : public MicroTacticsModel {

public:
ScienceVesselMicroTactics::ScienceVesselMicroTactics(Unit* u, InformationManagerAgent* i);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	virtual void move(Position p);
	void attachIntelligenceModule(InformationManagerAgent* a);
		virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* squadTarget;
	UnitModel* myTarget;
	int myTargetFitness;
	Position nextPoint;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	InformationManagerAgent* intelligenceModule;
	bool repairMode;
	UnitType knownType;
};


#endif