#include "ScienceVesselMicroTactics.h"
#include <cmath>
#include <ctime> 

ScienceVesselMicroTactics::ScienceVesselMicroTactics(Unit* u, InformationManagerAgent* i) {
	element = u;
	squadTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	myTarget = NULL;
	myTargetFitness = 0;
	repairMode = false;
	knownType = u->getType();
	intelligenceModule = i;
}

void ScienceVesselMicroTactics::move(Position p){
	element->move(p);
}

UnitType ScienceVesselMicroTactics::getKnownType() {
	return knownType;
}

void ScienceVesselMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
}


bool ScienceVesselMicroTactics::executeTactics() {
	int enemies = 0;
	if(element->getHitPoints() <= 0) {
		return true;
	}
	if(element->getHitPoints() <= element->getType().maxHitPoints()*0.6 && !repairMode) {
		element->move(intelligenceModule->findHighestConcentrationOf(UnitTypes::Terran_SCV));
		repairMode = true;
		////Broodwar->sendText("science vessell repair mode...");
		return true;
	}
	if(repairMode) {
		if(element->getHitPoints() == element->getType().maxHitPoints()) {
			repairMode = false;
		}
		return true;
	}


	std::set<BWAPI::Unit*> neighbours = element->getUnitsInRadius(element->getType().sightRange());
	if(!neighbours.empty() && element->getEnergy() >= 80 && ((Broodwar->enemy()->getRace() == Races::Zerg && Broodwar->self()->hasResearched(TechTypes::Irradiate)) || (Broodwar->enemy()->getRace() == Races::Protoss && Broodwar->self()->hasResearched(TechTypes::EMP_Shockwave)))) {
		int bestCluster = 0;
		Unit* bestTarget = NULL;
		Unit* targetTank = NULL;
		int lowestHP = 9000;
		for (std::set<BWAPI::Unit*>::const_iterator it = neighbours.begin(); it != neighbours.end(); ++it) {
			if((*it)->getPlayer() == Broodwar->enemy() && ((*it)->getType().maxShields() > 0 || (*it)->getType().isOrganic()) && (*it)->getPlayer() != Broodwar->self() && !(*it)->getType().isResourceContainer() && !(*it)->getType().isSpecialBuilding() && !(*it)->getType().isNeutral() && !(*it)->getType().isBuilding()) {
				enemies++;
				int cluster = 0;
				if(Broodwar->enemy()->getRace() == Races::Zerg || Broodwar->enemy()->getRace() == Races::Terran) {
					std::set<BWAPI::Unit*> nbrs = (*it)->getUnitsInRadius(64);
					for (std::set<BWAPI::Unit*>::const_iterator itt = nbrs.begin(); itt != nbrs.end(); ++itt) {
						if((*itt)->getType().isOrganic() && (*itt)->getPlayer() == Broodwar->enemy() && !(*itt)->getType().isBuilding()) {
							cluster++;
						}
					}
					if(cluster > bestCluster) {
						bestTarget = (*it);
						bestCluster = cluster;
					}
				}

				if(Broodwar->enemy()->getRace() == Races::Protoss) {
					std::set<BWAPI::Unit*> nbrs = (*it)->getUnitsInRadius(128);
					for (std::set<BWAPI::Unit*>::const_iterator itt = nbrs.begin(); itt != nbrs.end(); ++itt) {
						if(((*itt)->getType().maxShields() > 0 && (*itt)->getPlayer() == Broodwar->enemy())) {
							cluster++;
						}
					}
					if(cluster > bestCluster) {
						bestTarget = (*it);
						bestCluster = cluster;
					}
				}
			}
			if((*it)->getPlayer() == Broodwar->self() && ((*it)->getType() == Terran_Siege_Tank_Tank_Mode || (*it)->getType() == Terran_Siege_Tank_Siege_Mode)) {
				Unit* tank = *it;
				if(tank->getHitPoints() <= tank->getType().maxHitPoints()/3 && tank->isUnderAttack()) {
					targetTank = tank;
				}

			}
	}

		if(bestCluster >= 4 && bestTarget != NULL) {
			if(Broodwar->enemy()->getRace() == Races::Zerg || Broodwar->enemy()->getRace() == Races::Terran) {
				element->useTech(TechTypes::Irradiate, bestTarget);
			} else {
				element->useTech(TechTypes::EMP_Shockwave, bestTarget);
			}
		}
		if(targetTank != NULL && enemies > 3) {
			element->useTech(TechTypes::Defensive_Matrix, targetTank);
		}


	}

	if(enemies == 0 || element->getEnergy() < 80) {
		return false;
	}  else {
		return true;
	}
}

Unit* ScienceVesselMicroTactics::getUnit() {
	return element;
}

void ScienceVesselMicroTactics::attachIntelligenceModule(InformationManagerAgent* a) {
	intelligenceModule = a;
}