#include "Resource_GoalGeneratorHeaders.h"
#include "ResourceManagerAgent.h"
#include "InformationManagerAgent.h"

Resource_TrainWorkerGoalGenerator::Resource_TrainWorkerGoalGenerator(AgentPool* a, ResourceManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 5;
	thresh = 30; // was 35
	parent = par;
	goal = new GoalDescriptor(RESOURCE_TRAINWORKER, priority, 50, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Resource_TrainWorkerGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Resource_TrainWorkerGoalGenerator::inhibit() {

}

void Resource_TrainWorkerGoalGenerator::initialize() {

}

void Resource_TrainWorkerGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	//////////////////////agentPool->writeDebugMessage("train drive");
	if(!goal->accepted() && !goal->isExecuting()) {
		
		if(drive >= thresh) {
			if(instantiateGoal()) {
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			ResourceManagerAgent* r = (ResourceManagerAgent*)agentPool->getAgent("R");
			numMinerals = r->getNumMinerals();
			int workers = i->countUnitType(UnitTypes::Terran_SCV);
			goal->modifyPriority(goal->getGoalPriority()+1);

			if(workers < (numMinerals*1.7)+3) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}

	// monitor goal for accomplishment
	if(goal->isExecuting()) {
		if(goal->getMonitorTarget() != NULL) {
		if(goal->getMonitorTarget() != NULL && goal->getMonitorTarget()->isTraining()) {
	
			goal->relinquishResources();

		}
	
		if(goal->getMonitorTarget()->isCompleted()) {

			goal->relinquishResources();
			goal->finish();
			drive = 0;
	
		}
		}

	}



}

int Resource_TrainWorkerGoalGenerator::getthresh() {
	return thresh;
}

int Resource_TrainWorkerGoalGenerator::getdrive() {
	return drive;
}
/*

Implementation-specific functions.

*/

void Resource_TrainWorkerGoalGenerator::setInitialMineralPatchSize(int size) {
	numMinerals = size;
}