#ifndef RESOURCE_GOALHEADERS_H
#define RESOURCE_GOALHEADERS_H
#include "GoalGeneratorBase.h"
#include "GoalTypes.h"

class ResourceManagerAgent;

// worker training goal
class Resource_TrainWorkerGoalGenerator : public GoalGeneratorBase {
public:
	Resource_TrainWorkerGoalGenerator(AgentPool* a, ResourceManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	// what
	void setInitialMineralPatchSize(int num);

private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	ResourceManagerAgent* parent;
	GoalDescriptor* goal;

	// implementation-specific stuff, if needed
	int numMinerals; // count of how many mineral deposits are at the starting point


};

class Resource_BuildSupplyGoalGenerator : public GoalGeneratorBase {
public:
	Resource_BuildSupplyGoalGenerator(AgentPool* a, ResourceManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	// what, if needed


private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	ResourceManagerAgent* parent;
	GoalDescriptor* goal;
	int temporalFactor;
	// implementation-specific stuff, if needed


};

class Resource_BuildRefineryGoalGenerator : public GoalGeneratorBase {
public:
	Resource_BuildRefineryGoalGenerator(AgentPool* a, ResourceManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();

	// what, if needed


private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	ResourceManagerAgent* parent;
	GoalDescriptor* goal;

	// implementation-specific stuff, if needed


};



// worker training goal
class Resource_BuildExpansionGoalGenerator : public GoalGeneratorBase {
public:
	Resource_BuildExpansionGoalGenerator(AgentPool* a, ResourceManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	// what
	

private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	ResourceManagerAgent* parent;
	GoalDescriptor* goal;
		int temporalFactor;
	// implementation-specific stuff, if needed


};


class Resource_ClearObstructionsGoalGenerator : public GoalGeneratorBase {
public:
	Resource_ClearObstructionsGoalGenerator(AgentPool* a, ResourceManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	// what
	void setInitialMineralPatchSize(int num);

private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	ResourceManagerAgent* parent;
	GoalDescriptor* goal;
	int temporalFactor;

	// implementation-specific stuff, if needed


};


#endif