#include "Resource_GoalGeneratorHeaders.h"
#include "ResourceManagerAgent.h"


Resource_ClearObstructionsGoalGenerator::Resource_ClearObstructionsGoalGenerator(AgentPool* a, ResourceManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 55; // remember this
	thresh = 10;
	temporalFactor = 0;
	parent = par;
	goal = new GoalDescriptor(RESOURCE_CLEAROBSTRUCTIONS, priority, 0, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}


bool Resource_ClearObstructionsGoalGenerator::instantiateGoal() {
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
		return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Resource_ClearObstructionsGoalGenerator::inhibit() {

}

void Resource_ClearObstructionsGoalGenerator::initialize() {

}

void Resource_ClearObstructionsGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				temporalFactor = 0;
				drive = 0;
			}
		} else {
			int supplyUsed = Broodwar->self()->supplyUsed()/2;
			if(supplyUsed > 14 && i->hasUnit(UnitTypes::Terran_Barracks)) {
			
				if(!i->findLocalObstructions().empty()) {
					if(drive < thresh) {
						drive++;
					}
				}


			}
		}
	}
	BWAPI::Unit* worker = goal->getMonitorTarget();
	if(goal->isExecuting()) {
		//Broodwar->drawCircle(CoordinateType::Map, worker->getPosition().x(), worker->getPosition().y(), 10, Colors::Yellow, true);

		temporalFactor++;
		if(temporalFactor > 4000) {
			//////////agentPool->writeDebugMessage("clearing of obstruction ");
			//////////agentPool->writeDebugMessage("--- abandoning due to time constraints");	
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			worker->move((Position)Broodwar->self()->getStartLocation());
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			return;
		}
			if(i->findLocalObstructions().empty()) {
				goal->finish();
				temporalFactor = 0;
				agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				drive = 0;
		} 
	}
}

int Resource_ClearObstructionsGoalGenerator::getthresh() {
	return thresh;
}

int Resource_ClearObstructionsGoalGenerator::getdrive() {
	return drive;
}
/*

Implementation-specific functions.

*/

