#include "Resource_GoalGeneratorHeaders.h"
#include "ResourceManagerAgent.h"


Resource_BuildSupplyGoalGenerator::Resource_BuildSupplyGoalGenerator(AgentPool* a, ResourceManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 8; // remember this
	thresh = 25;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(RESOURCE_BUILDSUPPLY, priority, 100, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}


bool Resource_BuildSupplyGoalGenerator::instantiateGoal() {
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!i->hasUnitUnderConstruction(UnitTypes::Terran_Supply_Depot)) {
		return agentPool->getArbitrator()->declareIntention(goal);
	} 
	return false;
}

void Resource_BuildSupplyGoalGenerator::inhibit() {

}

void Resource_BuildSupplyGoalGenerator::initialize() {

}

void Resource_BuildSupplyGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
					temporalFactor = 0;
				// magic numbers!!s

				drive = 0;
			}
		} else {
			int supplyUsed = Broodwar->self()->supplyUsed();
			int totalSupply = Broodwar->self()->supplyTotal();
			if(supplyUsed > (totalSupply-12)) {

				if(drive < thresh) {
					drive++;
				}


			}
		}
	}
BWAPI::Unit* worker = goal->getMonitorTarget();
	if(goal->isExecuting()) {

		temporalFactor++;
		if(temporalFactor > 1300) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			worker->move((Position)Broodwar->self()->getStartLocation());
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			return;
		}

			if(worker->getBuildUnit() != NULL) {
				goal->relinquishResources();
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				if(worker->getBuildUnit()->isCompleted() || remainingBuildTime < 35) {
					goal->finish();
					temporalFactor = 0;
					goal->modifyPriority(goal->getGoalPriority()+3);
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
				}
			//}
		} else {
			if(worker != NULL) {
				if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
					goal->relinquishResources();
					goal->retry();
					temporalFactor = 0;
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
				}
			}
		}
	}


}

int Resource_BuildSupplyGoalGenerator::getthresh() {
	return thresh;
}

int Resource_BuildSupplyGoalGenerator::getdrive() {
	return drive;
}
/*

Implementation-specific functions.

*/

