#include "Resource_GoalGeneratorHeaders.h"
#include "ResourceManagerAgent.h"

Resource_BuildExpansionGoalGenerator::Resource_BuildExpansionGoalGenerator(AgentPool* a, ResourceManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 32; // remember this
	thresh = 60;
	parent = par;
	goal = new GoalDescriptor(RESOURCE_BUILDEXPANSION, priority, 400, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
	temporalFactor = 0;
}

bool Resource_BuildExpansionGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Resource_BuildExpansionGoalGenerator::inhibit() {

}

void Resource_BuildExpansionGoalGenerator::initialize() {

}

void Resource_BuildExpansionGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;




	ResourceManagerAgent* r = (ResourceManagerAgent*)agentPool->getAgent("R");
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	//////////////////////agentPool->writeDebugMessage("exp drive");
	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				drive = 0;
				temporalFactor = 0;
			}
		} else {


			std::vector<BaseModel*> bases = i->getBases();

			int baseModifier = 0;
			for (int k = 0; k < bases.size(); k++) {
				for(int l = 0; l < bases.at(k)->getLocalGas().size(); l++) {
					if(bases.at(k)->getLocalGas().at(l)->getUnit()->getResources() < bases.at(k)->getLocalGas().at(l)->getStartingResources()/3) {
						baseModifier++;
					}
				}
			}
			int baseBase = 0; // heh
			if(Broodwar->enemy()->getRace() == Races::Protoss){ 
					baseBase = i->countUnitType(Terran_Factory);
			} else {
					baseBase = 3;
			}

			if(Broodwar->self()->supplyUsed() >= 20 && i->getBases().size() < baseBase+baseModifier) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}

	if(goal->isExecuting()) {
		if(!goal->getTacticsMonitorTarget()->getUnit()->isMoving()) {
			temporalFactor++;
		}
		if(temporalFactor > 3000 || goal->getTacticsMonitorTarget()->getUnit()->getHitPoints() <= 0) {
			goal->relinquishResources();
			goal->retry();
			temporalFactor = 0;
			drive = 0;
			goal->getTacticsMonitorTarget()->getUnit()->stop();
			agentPool->getSquads()->getSquadByName("workers")->addUnit(goal->getTacticsMonitorTarget()->getUnit());
			return;
		}

		if(goal->getTacticsMonitorTarget()->executeTactics()) {
		} else {
				if(goal->getTacticsMonitorTarget()->getUnit()->getBuildUnit() != NULL) {
						goal->relinquishResources();
					if(goal->getTacticsMonitorTarget()->getUnit()->getBuildUnit()->getRemainingBuildTime() < 35 || goal->getTacticsMonitorTarget()->getUnit()->getBuildUnit()->isCompleted()) {
						i->addBase(goal->getTacticsMonitorTarget()->getUnit()->getTilePosition(), goal->getTacticsMonitorTarget()->getUnit()->getBuildUnit());
						goal->finish();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(goal->getTacticsMonitorTarget()->getUnit());
						drive = 0;
						temporalFactor = 0;
					}
			}
		}

	}
}



int Resource_BuildExpansionGoalGenerator::getthresh() {
	return thresh;
}

int Resource_BuildExpansionGoalGenerator::getdrive() {
	return drive;
}


/*

Implementation-specific functions.

*/

