#ifndef RESMANAGENT_H
#define RESMANAGENT_H
#include <vector>
#include "AgentBase.h"
#include "MineralModel.h"
#include "GasModel.h"
#include "ConstructionAgent.h"
#include "Resource_GoalGeneratorHeaders.h"
#include "GoalTypes.h"
#include "BaseModel.h"

class AgentPool;
//class SquadPool;

class ResourceManagerAgent : public AgentBase {
public:
	ResourceManagerAgent::ResourceManagerAgent(AgentPool* p);
	ResourceManagerAgent::ResourceManagerAgent();
	void ResourceManagerAgent::initialize();
	void ResourceManagerAgent::reassignIdleWorkers();
	void ResourceManagerAgent::regulateGas();
	void ResourceManagerAgent::administerBases();
	Unit* ResourceManagerAgent::getFreeGas();
	int ResourceManagerAgent::getNumMinerals();

	Arbitrator* ResourceManagerAgent::getInternalArbitrator();
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return internalArbitrator; };
	int ResourceManagerAgent::getNumWorkersMining(BaseModel* m);
		int ResourceManagerAgent::getNumWorkersGathering(BaseModel* m);
	std::vector<GoalGeneratorBase*> goalGenerators;
	std::vector<Unit*> ResourceManagerAgent::getWorkersAtBase(BaseModel* b);

private:
	AgentPool* agentPool;
	Arbitrator* internalArbitrator;
	Unit* ResourceManagerAgent::getFreeMineralSlot(Position p);
	Unit* ResourceManagerAgent::getFreeMineralSlot(BaseModel* m);
	int numWorkers;
	int numMinerals;



	// Goal generators
	Resource_TrainWorkerGoalGenerator* trainWorkersGoalGenerator;
	Resource_BuildSupplyGoalGenerator* buildSupplyGoalGenerator;
	Resource_BuildRefineryGoalGenerator* buildRefineryGoalGenerator;
	Resource_BuildExpansionGoalGenerator* buildExpansionGoalGenerator;
	Resource_ClearObstructionsGoalGenerator* clearObstructionsGoalGenerator;

};
#endif