#include "ResourceManagerAgent.h"
#include "AgentPool.h"
#include "InformationManagerAgent.h"
//#include "SquadPool.h"
ResourceManagerAgent::ResourceManagerAgent(AgentPool* p) {
	agentPool = p;
	internalArbitrator = new Arbitrator(p);

	buildSupplyGoalGenerator = new Resource_BuildSupplyGoalGenerator(agentPool, this);
	trainWorkersGoalGenerator = new Resource_TrainWorkerGoalGenerator(agentPool, this);
	buildRefineryGoalGenerator = new Resource_BuildRefineryGoalGenerator(agentPool, this);
	buildExpansionGoalGenerator = new Resource_BuildExpansionGoalGenerator(agentPool, this);
	clearObstructionsGoalGenerator = new Resource_ClearObstructionsGoalGenerator(agentPool, this);


	/// i think it was CSX that nick talked about, the logging thigng



	initialize();
}

ResourceManagerAgent::ResourceManagerAgent() {

}

Unit* ResourceManagerAgent::getFreeGas() {
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> bases = i->getBases();

	// just get the first one for now, but otherwise maybe think fo something smarteR?
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);

		if(!currentBase->getLocalGas().empty()) {
			for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
				GasModel* currentGas = currentBase->getLocalGas().at(k);

				if(!currentGas->hasRefinery()) {
					//////////////////////////////agentPool->writeDebugMessage("found free gas");
					return currentGas->getUnit();
				}
			}
		}
	}
	//////////////////////////////agentPool->writeDebugMessage("couldn't find free gas");
	return NULL;
}

void ResourceManagerAgent::initialize() {
	//////////////////////////////agentPool->writeDebugMessage("\t\tresource manager attempting to initialize");


	// add the initial crop of workers to the workers squad
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if ((*i)->getType().isWorker())
		{
			agentPool->getSquads()->getSquadByName("workers")->addUnit(*i);
			//////////////////////////////agentPool->writeDebugMessage("\t\tadded a unit to the workers group!");
		}
	} 
	//////////////////////////////agentPool->writeDebugMessage("\t\t\t assigning initial agents");

	/*	
	// record the gas geyser
	for(std::set<Unit*>::iterator m=Broodwar->getGeysers().begin();m!=Broodwar->getGeysers().end();m++) {
	if(agentPool->getMainBase()->getDistance(*m) < 300) {
	//////////////////////////////agentPool->writeDebugMessage("\t\t\t found a gas deposit");
	localGas = new GasModel(*m);
	// might be a bad idea - what if there is a map with multiple geysers?!
	break;
	}
	}

	// record all the minerals at our start location 
	for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++) {
	if(agentPool->getMainBase()->getDistance(*m) < 200) {
	//////////////////////////////agentPool->writeDebugMessage("\t\t\t found a mineral deposit");
	localMinerals.push_back(new MineralModel(*m));
	}
	}


	numMinerals = localMinerals.size();
	trainWorkersGoalGenerator->setInitialMineralPatchSize(numMinerals);
	*/
	/*
	numWorkers = agentPool->getSquads()->getSquadByName("workers")->getUnits().size();
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	for(unsigned int m = 0; m < numWorkers; i++) {
	Unit* worker = agentPool->getSquads()->getSquadByName("workers")->getUnitAt(m);
	for(unsigned int k = 0; k < i->getBases().at(0)->getLocalMinerals().size(); k++) {
	Unit* mineral = i->getBases().at(0)->getLocalMinerals().at(k)->getUnit();
	MineralModel* mineralMemory = i->getBases().at(0)->getLocalMinerals().at(k);
	if(mineralMemory->canBeMined()) {
	mineralMemory->assignUnit();
	worker->rightClick(mineral);
	break;
	}
	}
	}
	*/
}

void ResourceManagerAgent::administerBases() {

}

void ResourceManagerAgent::updateDrives() {

	// stuff the agent does by default
	//////////////////agentPool->writeDebugMessage("regulating gas");
	//regulateGas();
	//////////agentPool->writeDebugMessage("reassigning");
	if(Broodwar->getFrameCount()%32==0) { // was 32
		reassignIdleWorkers();
	}

	trainWorkersGoalGenerator->updateDrives();
	
	buildSupplyGoalGenerator->updateDrives();
	
	buildRefineryGoalGenerator->updateDrives();
	
	buildExpansionGoalGenerator->updateDrives();
	
	//clearObstructionsGoalGenerator->updateDrives();

}

int ResourceManagerAgent::getNumMinerals() {
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> bases = i->getBases();
	int numMins = 0;
	for(unsigned int i = 0; i < bases.size(); i++) {
		numMins+= bases.at(i)->getLocalMinerals().size();
	}
	//////////Broodwar->sendText("num minerals under my control: %d", numMins);
	return numMins;
}

void ResourceManagerAgent::regulateGas() {
	numWorkers = agentPool->getSquads()->getSquadByName("workers")->getUnits().size();

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> bases = i->getBases();
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);

		int numOnGas = 0;
		if(!currentBase->getLocalGas().empty()) {
			for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
				GasModel* currentGas = currentBase->getLocalGas().at(k);
				if(currentGas->hasRefinery()) {
					for(int i = 0; i < numWorkers; i++) {
						Unit* worker = agentPool->getSquads()->getSquadByName("workers")->getUnitAt(i);
						if(worker->isGatheringGas()) {
							numOnGas++;
						}
					}
					currentGas->assignUnitCount(numOnGas);
				}
			}
		}
	}

}
void ResourceManagerAgent::reassignIdleWorkers() {
	numWorkers = agentPool->getSquads()->getSquadByName("workers")->getUnits().size();
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> bases = i->getBases();
	//////////agentPool->writeDebugMessage("doing workers");
	//////////////////////////agentPool->writeDebugMessage((int)bases.size());

	if(bases.empty()) {
		return;
	}

	for (unsigned int i = bases.size(); i-- > 0; ) {
		BaseModel* currentBase = bases.at(i);
		if(!currentBase->isActive()) {
			continue;
		}
			//////////agentPool->writeDebugMessage("getting miners...");
		int miners = getNumWorkersMining(currentBase);
			//////////agentPool->writeDebugMessage("getting gas guys...");
		int gatherers = getNumWorkersGathering(currentBase);
			//////////agentPool->writeDebugMessage("getting guys at bas...");
		std::vector<Unit*> workersAtBase = getWorkersAtBase(currentBase);
		if(workersAtBase.empty()) {
			continue;
		}
			//////////agentPool->writeDebugMessage("eep");
		int numGasGatherers = gatherers;
		for(unsigned int k = 0; k < workersAtBase.size(); k++) {
			Unit* worker = workersAtBase.at(k);
			if((!worker->isConstructing() && !worker->isRepairing() && !worker->isMoving() && worker->isCompleted()) || worker->getOrder() == Orders::None) {
				std::vector<MineralModel*> mineralsAtBase = currentBase->getLocalMinerals();
				std::vector<GasModel*> gasAtBase = currentBase->getLocalGas();
				bool assigned = false;



				if(!gasAtBase.empty()) {
					//////////agentPool->writeDebugMessage("deeet");
					if(numGasGatherers < 3 ) {
						if(!worker->isGatheringGas()) {
							if(!currentBase->getLocalGas().empty()) {
							for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
								GasModel* currentGas = currentBase->getLocalGas().at(k);
								if(currentGas->hasRefinery() && currentGas->canBeMined()) {
									//////////agentPool->writeDebugMessage("to gas 1");
									worker->gather(currentGas->getUnit());
									numGasGatherers++;
									assigned = true;
									break;
								} 
							}
						}
						}

					}
						//////////agentPool->writeDebugMessage("arf");
				} else {
					//////////agentPool->writeDebugMessage("deeerrrrt");
					if(worker->isIdle() && numGasGatherers < 3){
					for (unsigned int j = bases.size(); j-- > 0; ) {
						if(!bases.at(j)->getLocalGas().empty()) {
							if(bases.at(j)->isActive() && !bases.at(j)->isUnderAttack()) {
							for(unsigned int k = 0; k < bases.at(j)->getLocalGas().size(); k++) {
								//GasModel* currentGas = bases.at(j)->getLocalGas().at(k);
								if(bases.at(j)->getLocalGas().at(k)->hasRefinery() && bases.at(j)->getLocalGas().at(k)->canBeMined()) {
									//////////agentPool->writeDebugMessage("to gas");
									worker->gather(bases.at(j)->getLocalGas().at(k)->getUnit());
									numGasGatherers++;
									assigned = true;
									break;
								} 
							}

							}
						}
					}
				}
			}
				if(assigned) {
					continue;
				}
				if(!mineralsAtBase.empty()) {
					if(!worker->isGatheringMinerals() && !worker->isGatheringGas()) {
						worker->gather(mineralsAtBase.at(rand()%mineralsAtBase.size())->getUnit());
						continue;
					}
				} else {
					// then look elsewhere?
					
						for (unsigned int j = bases.size(); j-- > 0; ) {
							if(!bases.at(j)->getLocalMinerals().empty()) {
							if(bases.at(j)->isActive() && !bases.at(j)->isUnderAttack()) {
								if(!worker->isGatheringMinerals() && !worker->isGatheringGas()) {
									worker->gather(bases.at(j)->getLocalMinerals().at(rand()%bases.at(j)->getLocalMinerals().size())->getUnit());
									break;
								}	
							}
						}
					// if we get there, there's serious trouble...
					InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
					
					BaseLocation* b = im->findClosestExpansionPoint();
					std::set<Unit*> mins = b->getMinerals();
					for(std::set<Unit*>::const_iterator em = mins.begin(); em != mins.end(); em++) {	
						if(!worker->isGatheringMinerals() && !worker->isGatheringGas() && rand()%100 > 50) {
									worker->gather((*em));
									break;
						}
					}



				}

			}
		}
	}
}
}




/*
for (unsigned int i = bases.size(); i-- > 0; ) {
//////////////////////////agentPool->writeDebugMessage("a");
BaseModel* currentBase = bases.at(i);
for(unsigned int i = 0; i < numWorkers; i++) {
//////////////////////////agentPool->writeDebugMessage("f");
Unit* worker = agentPool->getSquads()->getSquadByName("workers")->getUnitAt(i);
if(worker->isIdle() || worker->getOrder() == Orders::PlayerGuard || (!worker->isGatheringGas() && 
!worker->isGatheringMinerals() && 
!worker->isConstructing() && 
!worker->isMoving() && !worker->isRepairing())) {
//////////////////agentPool->writeDebugMessage("assigning woreker");

// deals with gas
if(!currentBase->getLocalGas().empty()) {
bool assigned = false;
for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
GasModel* currentGas = currentBase->getLocalGas().at(k);
if(currentGas->hasRefinery() && currentGas->canBeMined()) {
//////////////////agentPool->writeDebugMessage("to gas");
worker->gather(currentGas->getUnit());
assigned = true;
} 
}
if(assigned) {
continue;
}
}

// deals with minerals
///if(getNumWorkersMining(currentBase) < currentBase->getLocalMinerals().size()*2) {	
//////////////////agentPool->writeDebugMessage("to mins");
Unit* target = getFreeMineralSlot(worker->getPosition());
if(target != NULL) {
worker->gather(target);
//}
}
}
}
//	}
//	}
}
*/
	

	/*
	void ResourceManagerAgent::reassignIdleWorkers() {
	numWorkers = agentPool->getSquads()->getSquadByName("workers")->getUnits().size();
	//	//////////////////////////////agentPool->writeDebugMessage("discovered: ");
	////////////////////////////////agentPool->writeDebugMessage(numWorkers);
	////////////////////////////////agentPool->writeDebugMessage("workers");
	//	//////////////////////////////agentPool->writeDebugMessage("and");

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	std::vector<BaseModel*> bases = i->getBases();
	//////////////////////////agentPool->writeDebugMessage("base count");
	//////////////////////////agentPool->writeDebugMessage((int)bases.size());

	//	for(unsigned i = 0; i < bases.size(); i++) {
	for (unsigned int i = bases.size(); i-- > 0; ) {
	//////////////////////////agentPool->writeDebugMessage("a");
	BaseModel* currentBase = bases.at(i);
	//////////////////////////agentPool->writeDebugMessage("b");
	int numMining = getNumWorkersMining(currentBase);
	//////////////////////////agentPool->writeDebugMessage(numMining);
	//////////////////////////agentPool->writeDebugMessage("c");
	//if(currentBase->isActive()) {
	//////////////////////////agentPool->writeDebugMessage("d");
	if(numMining < currentBase->getLocalMinerals().size()) {	
	//////////////////////////agentPool->writeDebugMessage("e");
	for(unsigned int i = 0; i < numWorkers; i++) {
	//////////////////////////agentPool->writeDebugMessage("f");
	Unit* worker = agentPool->getSquads()->getSquadByName("workers")->getUnitAt(i);
	if(worker->isIdle() || worker->getOrder() == Orders::PlayerGuard || (!worker->isGatheringGas() && 
	!worker->isGatheringMinerals() && 
	!worker->isConstructing() && 
	!worker->isMoving()) || (worker->isRepairing() && !worker->getTarget()->isBeingHealed()) || (worker->isConstructing() && worker->getBuildUnit()->isCompleted())) {
	//////////////////////////agentPool->writeDebugMessage("assigning woreker");

	// deals with gas
	if(!currentBase->getLocalGas().empty()) {
	bool assigned = false;
	for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
	GasModel* currentGas = currentBase->getLocalGas().at(k);
	if(currentGas->hasRefinery() && currentGas->canBeMined()) {
	//////////////////////////agentPool->writeDebugMessage("to gas");
	worker->gather(currentGas->getUnit());
	assigned = true;
	} 
	}
	if(assigned) {
	continue;
	}
	}

	// deals with minerals
	if(getNumWorkersMining(currentBase) < currentBase->getLocalMinerals().size()*2) {	
	//////////////////////////agentPool->writeDebugMessage("to mins");
	worker->gather(getFreeMineralSlot(currentBase));
	}
	}
	}
	//////////////////////////agentPool->writeDebugMessage("dooooooooone");
	}
	//	}
	}
	}
	*/
	Unit* ResourceManagerAgent::getFreeMineralSlot(BaseModel* m) {

		for(unsigned int k = 0; k < m->getLocalMinerals().size(); k++) {
			Unit* mineral = m->getLocalMinerals().at(k)->getUnit();
			MineralModel* mineralMemory = m->getLocalMinerals().at(k);
			//if(mineralMemory->canBeMined()) {
			mineralMemory->assignUnit();
			return mineral;
			//}
		}
		return NULL;
	}

	Unit* ResourceManagerAgent::getFreeMineralSlot(Position p) {
		Unit* best = NULL;
		std::vector<Unit*> mineralsList;

		for(std::set<Unit*>::const_iterator k=Broodwar->self()->getUnits().begin();k!=Broodwar->self()->getUnits().end();k++) {
			if((*k)->getType() == UnitTypes::Terran_Command_Center) {
				for(std::set<Unit*>::const_iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++) {
					if((*m)->getDistance((*k)->getPosition()) < 400) {
						mineralsList.push_back((*m));
					}
				}
			}


		}

		for(unsigned int i = 0; i < mineralsList.size(); i++)	{
			if(best == NULL) {
				best = mineralsList.at(i);
			}
			if(mineralsList.at(i)->getDistance(p) < p.getDistance(best->getPosition()) && mineralsList.at(i)->getResources() > 0) {
				best = mineralsList.at(i);
			}
		}
		if(mineralsList.empty()) {
			return NULL;
		}
		return best;

	}

	int ResourceManagerAgent::getNumWorkersMining(BaseModel* m) {
		////////agentPool->writeDebugMessage("around...");
		////////agentPool->writeDebugMessage(m->getPosition().x());
		////////agentPool->writeDebugMessage(m->getPosition().y());
				////////agentPool->writeDebugMessage("is that valid?");
						////////agentPool->writeDebugMessage(m->getPosition().isValid());
		std::set<Unit*> units = Broodwar->getUnitsInRadius(m->getPosition(), 512);
		int total = 0;
		if(!units.empty()) {
		for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
			Unit* c = *i;
			if(c->getPlayer() == Broodwar->self()) {
			if(c->isCompleted()) {
				if(c->getType().isWorker()) {
				if(c->isGatheringMinerals() || c->isCarryingMinerals()) {
					total++;
				}
				}
			}
			}
		}
		}
		return total;
	}
	int ResourceManagerAgent::getNumWorkersGathering(BaseModel* m) {
		std::set<Unit*> units = Broodwar->getUnitsInRadius(m->getPosition(), 600);
		int total = 0;
		for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
			Unit* c = *i;
			if(c->isCompleted()) {
				if(c->getType().isWorker()){
					if(c->isGatheringGas() || c->isCarryingGas()) {
						total++;
					}
				}
			}
		}
		return total;
	}


	std::vector<Unit*> ResourceManagerAgent::getWorkersAtBase(BaseModel* b) {
		std::set<Unit*> units = Broodwar->getUnitsInRadius(b->getPosition(), 600);
		std::vector<Unit*> output;
		int total = 0;
		for(std::set<Unit*>::const_iterator i = units.begin(); i != units.end(); i++) {
			Unit* c = *i;
			if(c->getType().isWorker() && c->isCompleted()) {
				output.push_back(c);
			} 
		}
		return output;

	}


	Arbitrator* ResourceManagerAgent::getInternalArbitrator() {
		return internalArbitrator;
	}
