#include "Research_MechUtilHeaders.h"
#include "ResearchManagerAgent.h"

Research_WraithCloakGoalGenerator::Research_WraithCloakGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 13; // remember this
	thresh = 50;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_WRAITHCLOAK, priority, TechTypes::Cloaking_Field.mineralPrice(), TechTypes::Cloaking_Field.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_WraithCloakGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_WraithCloakGoalGenerator::inhibit() {

}

void Research_WraithCloakGoalGenerator::initialize() {

}

void Research_WraithCloakGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	//if(i->hasUnit(UnitTypes::Terran_Academy)) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {



				// firstly, do we already have stim packs?
				//////////////////////agentPool->writeDebugMessage("evaluating seige mode: ");
				//////////////////////agentPool->writeDebugMessage(!Broodwar->self()->hasResearched(TechTypes::Tank_Siege_Mode));
				//////////////////////agentPool->writeDebugMessage(i->hasUnit(UnitTypes::Terran_Factory));
				//////////////////////agentPool->writeDebugMessage(i->hasUnit(UnitTypes::Terran_Machine_Shop));



				if(!Broodwar->self()->hasResearched(TechTypes::Cloaking_Field) && i->getReccomendedFlyerType() == UnitTypes::Terran_Wraith && i->hasUnit(UnitTypes::Terran_Starport) && i->hasUnit(UnitTypes::Terran_Control_Tower)) {
					// cool, now this generator's responsibility is to lobby for
					// researching stim packs
					if(drive < thresh) {
						drive++;
					}
				}

			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isResearching() || Broodwar->self()->hasResearched(TechTypes::Cloaking_Field)) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingResearchTime();
				////////////////////////agentPool->writeDebugMessage("time left on research:");
				////////////////////////agentPool->writeDebugMessage(remainingResearchTime);
				//if(remainingResearchTime <= 10) {
					////////////////////////agentPool->writeDebugMessage("research done!");
					//goal->accept();
					goal->finish();
					drive = 0;
				//}
			}

			//if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}
			//if(Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) != 0) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}

		}
	//}
}


int Research_WraithCloakGoalGenerator::getthresh() {
	return thresh;
}

int Research_WraithCloakGoalGenerator::getdrive() {
	return drive;
}
