#include "Research_BuildingUpgradeHeaders.h"
#include "InformationManagerAgent.h"

Research_StarportUpgradeGoalGenerator::Research_StarportUpgradeGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 7; // remember this
	thresh = 50;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(UPGRADE_STARPORT, priority, UnitTypes::Terran_Control_Tower.mineralPrice(), UnitTypes::Terran_Control_Tower.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_StarportUpgradeGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to upgrade command centre");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_StarportUpgradeGoalGenerator::inhibit() {

}

void Research_StarportUpgradeGoalGenerator::initialize() {

}

void Research_StarportUpgradeGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!goal->accepted() && !goal->isExecuting()) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				if(i->countUnitType(UnitTypes::Terran_Starport) > i->countUnitType(UnitTypes::Terran_Control_Tower) && i->hasUnit(UnitTypes::Terran_Refinery)) {
					if(drive < thresh) {
						drive++;
					}
				}
			}

		}
	}
	if(goal->isExecuting()) {
		BWAPI::Unit* researchingInstution = goal->getMonitorTarget();
		////////////////////agentPool->writeDebugMessage("STARPORT getting construction time:");
		if(researchingInstution->getAddon() != NULL) {
				goal->relinquishResources();
			if(researchingInstution->isConstructing()) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingBuildTime();
				////////////////////agentPool->writeDebugMessage("STARPORT time left on upgrade build:");
				////////////////////agentPool->writeDebugMessage(remainingResearchTime);
				//if(remainingResearchTime <= 10) {
					////////////////////agentPool->writeDebugMessage("build done!");
					goal->finish();
				
					drive = 0;
				}
			//}

		}
	}
}


int Research_StarportUpgradeGoalGenerator::getthresh() {
	return thresh;
}

int Research_StarportUpgradeGoalGenerator::getdrive() {
	return drive;
}
